/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.QuestionTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.examine.dao.ExamQuestionsInfoDao;
import com.artfess.examine.dao.ExamQuestionsOptionDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.manager.ExamQuestionsOptionManager;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamQuestionsOption;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.QuestionAnalysisVo;
import com.artfess.examine.vo.StatisticalReqVo;
import com.artfess.examine.vo.SubjectQuestionTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamQuestionsInfoManagerImpl
extends BaseManagerImpl<ExamQuestionsInfoDao, ExamQuestionsInfo>
implements ExamQuestionsInfoManager {
    @Resource
    private ExamQuestionsOptionDao questionsOptionDao;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Autowired
    private ExamQuestionsOptionManager questionsOptionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createInfo(ExamQuestionsInfo t) {
        int insert;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_id_", (Object)t.getSubId());
        queryWrapper.eq((Object)"question_", (Object)t.getQuestion());
        List questionsInfos = ((ExamQuestionsInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)questionsInfos)) {
            throw new RuntimeException("\u8be5\u8bfe\u76ee\u4e0b\u9898\u76ee\u5df2\u91cd\u590d\uff01");
        }
        if (!(QuestionTypeEnum.shortAnswer.getType().equals(t.getType()) || QuestionTypeEnum.operation.getType().equals(t.getType()) || QuestionTypeEnum.lst.getType().equals(t.getType()))) {
            Assert.hasText((String)t.getRightOption(), (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7b54\u6848");
        }
        if ((insert = ((ExamQuestionsInfoDao)this.baseMapper).insert((Object)t)) > 0) {
            this.processOptions(t.getOptions(), t.getId());
            return t.getId();
        }
        return null;
    }

    private void processOptions(List<ExamQuestionsOption> options, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"question_id_", (Object)id);
        this.questionsOptionDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(options)) {
            return;
        }
        options.forEach(option -> {
            Assert.hasText((String)option.getOptionKey(), (String)"\u9009\u9879\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)option.getOptionContent(), (String)"\u9009\u9879\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            option.setQuestionId(id);
            this.questionsOptionDao.insert(option);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateInfo(ExamQuestionsInfo t) {
        int count;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_id_", (Object)t.getSubId());
        queryWrapper.eq((Object)"question_", (Object)t.getQuestion());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List questionsInfos = ((ExamQuestionsInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)questionsInfos)) {
            throw new RuntimeException("\u8be5\u8bfe\u76ee\u4e0b\u9898\u76ee\u5df2\u91cd\u590d\uff01");
        }
        if (!(QuestionTypeEnum.shortAnswer.getType().equals(t.getType()) || QuestionTypeEnum.operation.getType().equals(t.getType()) || QuestionTypeEnum.lst.getType().equals(t.getType()))) {
            Assert.hasText((String)t.getRightOption(), (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7b54\u6848");
        }
        if ((count = ((ExamQuestionsInfoDao)this.baseMapper).updateById((Object)t)) > 0) {
            this.processOptions(t.getOptions(), t.getId());
            return t.getId();
        }
        return null;
    }

    @Override
    public ExamQuestionsInfo findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8bd5\u9898");
        ExamQuestionsInfo examQuestionsInfo = (ExamQuestionsInfo)((Object)((ExamQuestionsInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examQuestionsInfo), (String)"\u9898\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728");
        String subId = examQuestionsInfo.getSubId();
        ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)this.subjectInfoDao.selectById((Serializable)((Object)subId)));
        if (null != examSubjectInfo) {
            examQuestionsInfo.setSubjectName(examSubjectInfo.getName());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"question_id_", (Object)id);
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)queryWrapper);
        examQuestionsInfo.setOptions(examQuestionsOptions);
        return examQuestionsInfo;
    }

    @Override
    public List<ExamQuestionsInfo> randomQuestion(String subjectId, String questionType, Integer numuber) {
        return ((ExamQuestionsInfoDao)this.baseMapper).randomQuestion(subjectId, questionType, numuber);
    }

    @Override
    public List<SubjectQuestionTypeVo> findBySubjectId(String subjectId) {
        List<SubjectQuestionTypeVo> list = ((ExamQuestionsInfoDao)this.baseMapper).findBySubjectId(subjectId);
        return list;
    }

    @Override
    public PageList<ExamQuestionsInfo> findByPage(QueryFilter<ExamQuestionsInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamQuestionsInfo> result = ((ExamQuestionsInfoDao)this.baseMapper).findByPage((IPage<ExamQuestionsInfo>)this.convert2IPage(pageBean), (Wrapper<ExamQuestionsInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public QuestionAnalysisVo questionAnalysis(StatisticalReqVo reqVo) {
        QuestionAnalysisVo questionAnalysisVo = new QuestionAnalysisVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        if (!StringUtils.isEmpty((Object)reqVo.getSubjectId())) {
            queryWrapper.eq((Object)"sub_id_", (Object)reqVo.getSubjectId());
        }
        queryWrapper.isNotNull((Object)"type_");
        List questionsInfos = ((ExamQuestionsInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        questionsInfos.forEach(question -> question.setDifficulty("1"));
        Map<String, List<ExamQuestionsInfo>> map = questionsInfos.stream().collect(Collectors.groupingBy(ExamQuestionsInfo::getType));
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            SubjectQuestionTypeVo subjectQuestionTypeVo = new SubjectQuestionTypeVo();
            subjectQuestionTypeVo.setType((String)key);
            subjectQuestionTypeVo.setCount(value.size());
            Map<String, List<ExamQuestionsInfo>> dMap = value.stream().collect(Collectors.groupingBy(ExamQuestionsInfo::getDifficulty));
            dMap.forEach((dkey, dvalue) -> {
                if (StringUtils.isEmpty((Object)dkey)) {
                    return;
                }
                Integer size = 0;
                if (!CollectionUtils.isEmpty((Collection)dvalue)) {
                    size = dvalue.size();
                }
                if ("1".equals(dkey)) {
                    subjectQuestionTypeVo.setSimple(size);
                }
                if ("2".equals(dkey)) {
                    subjectQuestionTypeVo.setOrdinary(size);
                }
                if ("3".equals(dkey)) {
                    subjectQuestionTypeVo.setDifficult(size);
                }
            });
            list.add(subjectQuestionTypeVo);
        });
        questionAnalysisVo.setQuestionTypeVos(list);
        Map<String, List<ExamQuestionsInfo>> dMap = questionsInfos.stream().collect(Collectors.groupingBy(ExamQuestionsInfo::getDifficulty));
        JSONObject jsObject = new JSONObject();
        dMap.forEach((dkey, dvalue) -> {
            if (StringUtils.isEmpty((Object)dkey)) {
                return;
            }
            Integer size = 0;
            if (!CollectionUtils.isEmpty((Collection)dvalue)) {
                size = dvalue.size();
            }
            jsObject.put(dkey, (Object)size);
        });
        questionAnalysisVo.setDifficultPercentage(jsObject);
        return questionAnalysisVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(ExamQuestionsInfo question) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_id_", (Object)question.getSubId());
        queryWrapper.eq((Object)"question_", (Object)question.getQuestion());
        List questionsInfos = ((ExamQuestionsInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)questionsInfos)) {
            // empty if block
        }
        if (StringUtil.isEmpty((String)question.getRightOption())) {
            throw new RuntimeException(question.getQuestion() + "\u8bf7\u586b\u5199\u6b63\u786e\u7b54\u6848\uff01");
        }
        question.setType(QuestionTypeEnum.getType((String)question.getType()));
        if (QuestionTypeEnum.radio.getType().equals(question.getType()) && question.getRightOption().length() > 1) {
            question.setType(QuestionTypeEnum.multi.getType());
            question.setRightOption(org.apache.commons.lang3.StringUtils.join((Object[])question.getRightOption().split(""), (String)","));
        } else if (QuestionTypeEnum.fillIn.getType().equals(question.getType()) || QuestionTypeEnum.lst.getType().equals(question.getType()) || QuestionTypeEnum.judge.getType().equals(question.getType())) {
            Assert.hasText((String)question.getRightOption(), (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7b54\u6848");
            question.setRightOption(question.getRightOption());
        } else if (QuestionTypeEnum.judge.getType().equals(question.getType())) {
            Assert.hasText((String)question.getRightOption(), (String)"\u8bf7\u586b\u5199\u6b63\u786e\u7b54\u6848");
            if ("\u5bf9".equals(question.getRightOption())) {
                question.setRightOption("1");
            } else if ("\u9519".equals(question.getRightOption())) {
                question.setRightOption("0");
            }
        } else if (QuestionTypeEnum.multi.getType().equals(question.getType())) {
            question.setRightOption(org.apache.commons.lang3.StringUtils.join((Object[])question.getRightOption().split(""), (String)","));
        }
        question.setDifficulty("1");
        question.setScore(new BigDecimal(5));
        int insert = ((ExamQuestionsInfoDao)this.baseMapper).insert((Object)question);
        if (insert > 0) {
            if (QuestionTypeEnum.radio.getType().equals(question.getType()) || QuestionTypeEnum.multi.getType().equals(question.getType())) {
                ArrayList optionList = Lists.newArrayList();
                ExamQuestionsOption option = new ExamQuestionsOption();
                option.setOptionKey("A");
                option.setQuestionId(question.getId());
                String optionContent = question.getOptionOne();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionOne().substring(2);
                }
                option.setOptionContent(optionContent);
                optionList.add(option);
                option = new ExamQuestionsOption();
                option.setOptionKey("B");
                option.setQuestionId(question.getId());
                optionContent = question.getOptionTwo();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionTwo().substring(2);
                    option.setOptionContent(optionContent);
                    optionList.add(option);
                }
                option = new ExamQuestionsOption();
                option.setOptionKey("C");
                option.setQuestionId(question.getId());
                optionContent = question.getOptionThree();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionThree().substring(2);
                    option.setOptionContent(optionContent);
                    optionList.add(option);
                }
                option = new ExamQuestionsOption();
                option.setOptionKey("D");
                option.setQuestionId(question.getId());
                optionContent = question.getOptionFour();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionFour().substring(2);
                    option.setOptionContent(optionContent);
                    optionList.add(option);
                }
                option = new ExamQuestionsOption();
                option.setOptionKey("E");
                option.setQuestionId(question.getId());
                optionContent = question.getOptionFive();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionFive().substring(2);
                    option.setOptionContent(optionContent);
                    optionList.add(option);
                }
                option = new ExamQuestionsOption();
                option.setOptionKey("F");
                option.setQuestionId(question.getId());
                optionContent = question.getOptionSix();
                if (!StringUtils.isEmpty((Object)optionContent) && optionContent.length() > 2) {
                    optionContent = question.getOptionSix().substring(2);
                    option.setOptionContent(optionContent);
                    optionList.add(option);
                }
                this.questionsOptionService.saveBatch(optionList);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ExamQuestionsInfo> getQuestionList(List<String> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"sub_id_", idList);
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        return ((ExamQuestionsInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

