/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectPos;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.SubjectReqVo;
import com.artfess.examine.vo.UserInfoVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u79d1\u76ee\u7ba1\u7406"})
@RequestMapping(value={"/exam/subject/info/"})
@ApiGroup(group={"group_biz"})
public class ExamSubjectInfoController
extends BaseController<ExamSubjectInfoManager, ExamSubjectInfo> {
    private static final Logger log = LoggerFactory.getLogger(ExamSubjectInfoController.class);
    @Autowired
    private ExamQuestionsInfoManager questionsInfoManager;

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u79d1\u76ee\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u79d1\u76ee\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u79d1\u76ee\u4e0b\u62c9\u6811") @RequestBody ExamSubjectInfo entity) {
        log.info("\u83b7\u53d6\u79d1\u76ee\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<ExamSubjectType> list = ((ExamSubjectInfoManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/findByPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e13\u4e1a\u88c5\u5907\u83b7\u53d6\u5bf9\u5e94\u79d1\u76ee\u4fe1\u606f")
    public PageList<ExamSubjectInfo> findByPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamSubjectInfo> queryFilter) {
        queryFilter.addFilter("s.IS_DELE_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.create_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((ExamSubjectInfoManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/notSubjectPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u672a\u88ab\u5e74\u5ea6\u8003\u6838\u9009\u62e9\u7684\u79d1\u76ee\u4fe1\u606f")
    public PageList<ExamSubjectInfo> notSubjectPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamSubjectInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        return ((ExamSubjectInfoManager)this.baseService).notSubjectPage(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamSubjectInfo t) {
        boolean result = ((ExamSubjectInfoManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamSubjectInfo t) {
        boolean result = ((ExamSubjectInfoManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/posList/{id}"})
    @ApiOperation(value="\u8bd5\u5377-\u6839\u636e\u8bfe\u76eeid\u83b7\u53d6\u5df2\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u5c97\u4f4d\uff08\uff09")
    public List<ExamSubjectPos> findByBindPos(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamSubjectInfoManager)this.baseService).findByBindPos(id);
    }

    @GetMapping(value={"/findById/{id}"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f")
    public ExamSubjectInfo findById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamSubjectInfoManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/findBySubjectIds"})
    @ApiOperation(value="\u8bd5\u5377-\u6839\u636e\u9009\u4e2d\u8bfe\u76eeid\u83b7\u53d6\u5df2\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u5c97\u4f4d\uff08\u8003\u8bd5\u9009\u62e9\u8bfe\u76ee\u540e\u8c03\u7528\uff09")
    public List<ExamSubjectPos> findBySubjectIds(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestBody SubjectReqVo t) {
        return ((ExamSubjectInfoManager)this.baseService).findBySubjectIds(t);
    }

    @PostMapping(value={"/getSubjectList"})
    @ApiOperation(value="\u6839\u636e\u79d1\u76eeid\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f")
    public List<ExamSubjectInfo> getSubjectList(@ApiParam(name="SubjectReqVo", value="\u5b9e\u4f53") @RequestBody SubjectReqVo t) {
        return ((ExamSubjectInfoManager)this.baseService).getSubjectList(t);
    }

    @PostMapping(value={"/getSubjectUserList"})
    @ApiOperation(value="\u6839\u636e\u9009\u4e2d\u79d1\u76eeid\u83b7\u53d6\u79d1\u76ee\u4e0b\u5c97\u4f4d\u5173\u8054\u4eba\u5458")
    public List<UserInfoVo> getSubjectUserList(@ApiParam(name="SubjectReqVo", value="\u5b9e\u4f53") @RequestBody SubjectReqVo t) {
        return ((ExamSubjectInfoManager)this.baseService).getSubjectUserList(t);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(ExamSubjectInfo.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((ExamSubjectInfoManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25");
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamSubjectInfo> queryFilter) throws Exception {
        PageList<ExamSubjectInfo> page = ((ExamSubjectInfoManager)this.baseService).findByPage(queryFilter);
        ExcelUtils util = new ExcelUtils(ExamSubjectInfo.class);
        util.exportExcel(response, request, page.getRows(), "\u8bfe\u76ee\u4fe1\u606f");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/subject.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u8bfe\u76ee\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        List<ExamQuestionsInfo> list = this.questionsInfoManager.getQuestionList(idList);
        if (!CollectionUtils.isEmpty(list)) {
            throw new BaseException("\u8be5\u8bfe\u76ee\u4e0b\u8fd8\u6709\u9898\u76ee\uff0c\u8bf7\u5148\u5220\u9664\u9898\u76ee\u4fe1\u606f");
        }
        boolean result = ((ExamSubjectInfoManager)this.baseService).removeByIds(idList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/coachSubjectList"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6559\u7ec3\u8bad\u7ec3\u8bfe\u76ee\u5217\u8868")
    public PageList<UserInfoVo> coachSubjectList(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamSubjectInfo> queryFilter) {
        return ((ExamSubjectInfoManager)this.baseService).coachSubjectList(queryFilter);
    }
}

