/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.data.dao.BizExamSpaceDataDao;
import com.artfess.data.manager.BizEquipmentBaseDataManager;
import com.artfess.data.manager.BizExamIndexDataManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.manager.BizTrainEquipmentDataManager;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizExamSpaceDataManagerImpl
extends BaseManagerImpl<BizExamSpaceDataDao, BizExamSpaceData>
implements BizExamSpaceDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Autowired
    private BizExamIndexDataManager indexDataManager;
    @Autowired
    private BizTrainEquipmentDataManager trainEquipmentDataManager;
    @Autowired
    private BizEquipmentBaseDataManager equipmentBaseDataManager;

    @Override
    public void saveList(List<BizExamSpaceData> list) {
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText((String)data.getName(), (String)"\u8bf7\u586b\u5199\u573a\u5730\u540d\u79f0");
            if (null != DictionaryUtils.getDictInfo((String)"cdlx", (String)data.getType())) {
                String type = DictionaryUtils.getDictInfo((String)"cdlx", (String)data.getType()).getValue();
                data.setType(type);
            }
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(data.getAccountabilityOrg())) {
                data.setOrgId(((OrgVo)((Object)((Object)orgMap.get(data.getAccountabilityOrg())))).getId());
            }
        });
        this.saveBatch(list);
    }

    @Override
    public JSONObject trainSafeguard() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizExamSpaceData::getIsDele, (Object)DelStatusEnum.N.getType());
        Integer spaceCount = ((BizExamSpaceDataDao)this.baseMapper).selectCount((Wrapper)lambdaQueryWrapper);
        return null;
    }

    @Override
    public List<JSONObject> spacePancake(TrainReqVo reqVo) {
        return ((BizExamSpaceDataDao)this.baseMapper).spacePancake(reqVo);
    }
}

