/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.alibaba.fastjson.JSON;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.util.AppUtil;
import com.artfess.base.vo.DictionaryDetailVo;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public class DictionaryUtils {
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault("\u5b57\u5178\u7f13\u5b58");

    public static DictionaryDetailVo getDictInfo(String dictKey, String dictName) {
        String key;
        if (!StringUtils.isNotEmpty((String)dictName)) {
            return new DictionaryDetailVo();
        }
        CacheManager cacheManager = AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        Object o = cache.get(key = "sys:dictionary::" + dictKey.toUpperCase() + ":");
        if (null == o) {
            return new DictionaryDetailVo();
        }
        List dictionaryDetails = JSON.parseArray((String)o.toString(), DictionaryDetailVo.class);
        AtomicReference value = new AtomicReference();
        dictionaryDetails.forEach(dictionaryDetail -> {
            String name = dictionaryDetail.getName();
            if (dictName.equals(name)) {
                value.set(dictionaryDetail);
                return;
            }
        });
        return (DictionaryDetailVo)value.get();
    }

    public static DictionaryDetailVo findByDictValue(String dictKey, String dictValue) {
        String key;
        if (!StringUtils.isNotEmpty((String)dictValue)) {
            return new DictionaryDetailVo();
        }
        CacheManager cacheManager = AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        Object o = cache.get(key = "sys:dictionary::" + dictKey.toUpperCase() + ":");
        if (null == o) {
            return new DictionaryDetailVo();
        }
        List dictionaryDetails = JSON.parseArray((String)o.toString(), DictionaryDetailVo.class);
        AtomicReference value = new AtomicReference();
        dictionaryDetails.forEach(dictionaryDetail -> {
            String dictionaryDetailValue = dictionaryDetail.getValue();
            if (dictValue.equals(dictionaryDetailValue)) {
                value.set(dictionaryDetail);
                return;
            }
        });
        return (DictionaryDetailVo)value.get();
    }
}

