/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.job.persistence.manager;

import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.job.model.ParameterObj;
import com.artfess.job.model.PlanObject;
import com.artfess.job.model.SchedulerVo;
import com.artfess.job.util.ConvertUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.constant.Constable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.stereotype.Service;

@Service
public class SchedulerService {
    @Resource
    Scheduler scheduler;
    private static HashMap<String, String> mapWeek = new HashMap();
    @Resource
    BaseContext baseContext;

    public void addSimpleTrigger(String jobName, String trigName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey jobKey = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(trigName, this.baseContext.getCurrentTenantId()).startAt(new Date());
        tb.forJob(jobKey);
        SimpleTrigger trig = (SimpleTrigger)tb.build();
        this.scheduler.scheduleJob((Trigger)trig);
    }

    public boolean addJob(String jobName, String className, String parameterJson, String description) throws Exception {
        if (this.scheduler == null) {
            return false;
        }
        Class<?> cls = Class.forName(className);
        JobBuilder jb = JobBuilder.newJob(cls);
        jb.withIdentity(jobName, this.baseContext.getCurrentTenantId());
        if (StringUtils.isNotEmpty((String)parameterJson)) {
            this.setJobMap(parameterJson, jb);
        }
        jb.storeDurably();
        jb.withDescription(description);
        JobDetail jobDetail = jb.build();
        this.scheduler.addJob(jobDetail, true);
        return true;
    }

    public CommonResult<String> addJob(String jobName, String className, Map<String, Object> parameterMap, String description) throws SchedulerException {
        Class<?> cls;
        if (this.scheduler == null) {
            return new CommonResult(false, "scheduler \u6ca1\u6709\u914d\u7f6e!", null);
        }
        boolean isJobExist = this.isJobExists(jobName);
        if (isJobExist) {
            return new CommonResult(false, "\u4efb\u52a1\u5df2\u5b58\u5728", null);
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return new CommonResult(false, "\u6307\u5b9a\u7684\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u5b9e\u73b0JOB\u63a5\u53e3", null);
        }
        try {
            return this.addJob(jobName, cls, parameterMap, description);
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage(), null);
        }
    }

    public CommonResult<String> addJob(String jobName, Class<?> cls, Map<String, Object> parameterMap, String description) {
        if (this.scheduler == null) {
            return new CommonResult(false, "scheduler \u6ca1\u6709\u914d\u7f6e!", null);
        }
        try {
            JobBuilder jb = JobBuilder.newJob(cls);
            jb.withIdentity(jobName, this.baseContext.getCurrentTenantId());
            if (parameterMap != null) {
                JobDataMap map = new JobDataMap();
                map.putAll(parameterMap);
                jb.usingJobData(map);
            }
            jb.storeDurably();
            jb.withDescription(description);
            JobDetail jobDetail = jb.build();
            this.scheduler.addJob(jobDetail, true);
            return new CommonResult(true, "\u6dfb\u52a0\u4efb\u52a1\u6210\u529f!", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6dfb\u52a0\u4efb\u52a1\u5931\u6557!", null);
        }
    }

    public boolean isJobExists(String jobName) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        return this.scheduler.checkExists(key);
    }

    public List<SchedulerVo> getJobList() throws SchedulerException {
        if (this.scheduler == null) {
            return new ArrayList<SchedulerVo>();
        }
        ArrayList<SchedulerVo> list = new ArrayList<SchedulerVo>();
        GroupMatcher matcher = GroupMatcher.groupEquals((String)this.baseContext.getCurrentTenantId());
        Set set = this.scheduler.getJobKeys(matcher);
        for (JobKey jobKey : set) {
            JobDetail detail = this.scheduler.getJobDetail(jobKey);
            list.add(ConvertUtil.toBean(detail));
        }
        return list;
    }

    public SchedulerVo getJobDetail(String key) throws Exception {
        JobKey jobKey = new JobKey(key, this.baseContext.getCurrentTenantId());
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        return ConvertUtil.toJobBean(jobDetail);
    }

    public List<Trigger> getTriggersByJob(String jobName) throws SchedulerException {
        if (this.scheduler == null) {
            return new ArrayList<Trigger>();
        }
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        return this.scheduler.getTriggersOfJob(key);
    }

    public HashMap<String, Trigger.TriggerState> getTriggerStatus(List<Trigger> list) throws SchedulerException {
        if (this.scheduler == null) {
            return new HashMap<String, Trigger.TriggerState>();
        }
        HashMap<String, Trigger.TriggerState> map = new HashMap<String, Trigger.TriggerState>();
        for (Trigger trigger : list) {
            TriggerKey key = trigger.getKey();
            Trigger.TriggerState state = this.scheduler.getTriggerState(key);
            map.put(key.getName(), state);
        }
        return map;
    }

    public boolean isTriggerExists(String trigName) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        TriggerKey triggerKey = new TriggerKey(trigName, this.baseContext.getCurrentTenantId());
        return this.scheduler.checkExists(triggerKey);
    }

    public void addTrigger(String jobName, String trigName, String planJson) throws Exception {
        if (this.scheduler == null) {
            return;
        }
        JobKey jobKey = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(trigName, this.baseContext.getCurrentTenantId());
        this.setTrigBuilder(planJson, (TriggerBuilder<Trigger>)tb);
        tb.forJob(jobKey);
        Trigger trig = tb.build();
        this.scheduler.scheduleJob(trig);
    }

    public void addTrigger(String jobName, String trigName, int minute) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey jobKey = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(trigName, this.baseContext.getCurrentTenantId());
        CalendarIntervalScheduleBuilder sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMinutes(minute);
        tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + minute + "\u5206\u949f\u6267\u884c!").forJob(jobKey);
        Trigger trig = tb.build();
        this.scheduler.scheduleJob(trig);
    }

    public void addTrigger(String jobName, String trigName, int rate, String rateUnit) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey jobKey = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(trigName, this.baseContext.getCurrentTenantId());
        CalendarIntervalScheduleBuilder sb = null;
        if (rateUnit.equals("s")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInSeconds(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u79d2\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("m")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMinutes(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u5206\u949f\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("h")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInHours(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u5c0f\u65f6\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("d")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInDays(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u5929\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("w")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInWeeks(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u5468\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("M")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMonths(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u6708\u6267\u884c!").forJob(jobKey);
        } else if (rateUnit.equals("Y")) {
            sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInYears(rate);
            tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + rate + "\u5e74\u6267\u884c!").forJob(jobKey);
        }
        Trigger trig = tb.build();
        this.scheduler.scheduleJob(trig);
    }

    private void setTrigBuilder(String planJson, TriggerBuilder<Trigger> tb) throws Exception {
        PlanObject planObject = (PlanObject)JsonUtil.toBean((String)planJson, PlanObject.class);
        int type = planObject.getType();
        String value = planObject.getTimeInterval();
        CronScheduleBuilder sb = null;
        switch (type) {
            case 1: {
                LocalDateTime lt = DateFormatUtil.parseDateTime((String)value);
                ZoneId zoneId = ZoneId.systemDefault();
                ZonedDateTime zdt = lt.atZone(zoneId);
                Date date = Date.from(zdt.toInstant());
                tb.startAt(date).withDescription("\u6267\u884c\u4e00\u6b21,\u6267\u884c\u65f6\u95f4:" + date.toLocaleString());
                break;
            }
            case 2: {
                int minute = Integer.parseInt(value);
                sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMinutes(minute);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + minute + "\u5206\u949f\u6267\u884c!");
                break;
            }
            case 3: {
                String[] aryTime = value.split(":");
                int hour = Integer.parseInt(aryTime[0]);
                int m = Integer.parseInt(aryTime[1]);
                sb = CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)m);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5929\uff1a" + hour + ":" + m + "\u6267\u884c!");
                break;
            }
            case 4: {
                String[] aryExpression = value.split("[|]");
                String week = aryExpression[0];
                String[] aryTime1 = aryExpression[1].split(":");
                String h1 = aryTime1[0];
                String m1 = aryTime1[1];
                String cronExperssion = "0 " + m1 + " " + h1 + " ? * " + week;
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5468\uff1a" + this.getWeek(week) + "," + h1 + ":" + m1 + "\u6267\u884c!");
                break;
            }
            case 5: {
                String[] aryExpression5 = value.split("[|]");
                String day = aryExpression5[0];
                String[] aryTime2 = aryExpression5[1].split(":");
                String h2 = aryTime2[0];
                String m2 = aryTime2[1];
                String cronExperssion1 = "0 " + m2 + " " + h2 + " " + day + " * ?";
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion1);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u6708:" + this.getDay(day) + "," + h2 + ":" + m2 + "\u6267\u884c!");
                break;
            }
            case 6: {
                sb = CronScheduleBuilder.cronSchedule((String)value);
                tb.startNow().withSchedule((ScheduleBuilder)sb);
                tb.withDescription("CronTrigger\u8868\u8fbe\u5f0f:" + value);
            }
        }
    }

    private String getDay(String day) {
        String[] aryDay = day.split(",");
        int len = aryDay.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            String tmp = aryDay[i];
            tmp = tmp.equals("L") ? "\u6700\u540e\u4e00\u5929" : tmp;
            str = i < len - 1 ? str + tmp + "," : str + tmp;
        }
        return str;
    }

    private String getWeek(String week) {
        String[] aryWeek = week.split(",");
        int len = aryWeek.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = i < len - 1 ? str + mapWeek.get(aryWeek[i]) + "," : str + mapWeek.get(aryWeek[i]);
        }
        return str;
    }

    private void setJobMap(String json, JobBuilder job) throws Exception {
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ParameterObj>>(){});
        for (ParameterObj obj : list) {
            Constable val;
            String type = obj.getType();
            String name = obj.getName();
            String value = obj.getValue();
            if (type.equals("int")) {
                val = StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
                job.usingJobData(name, val);
                continue;
            }
            if (type.equals("long")) {
                val = StringUtils.isEmpty((String)value) ? 0L : Long.parseLong(value);
                job.usingJobData(name, (Long)val);
                continue;
            }
            if (type.equals("float")) {
                val = Float.valueOf(StringUtils.isEmpty((String)value) ? 0.0f : Float.parseFloat(value));
                job.usingJobData(name, (Float)val);
                continue;
            }
            if (type.equals("boolean")) {
                val = Boolean.valueOf(StringUtils.isEmpty((String)value) ? false : Boolean.parseBoolean(value));
                job.usingJobData(name, (Boolean)val);
                continue;
            }
            job.usingJobData(name, value);
        }
    }

    public void delJob(String jobName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        this.scheduler.deleteJob(key);
    }

    public Trigger getTrigger(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return null;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        return this.scheduler.getTrigger(key);
    }

    public void delTrigger(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        this.scheduler.unscheduleJob(key);
    }

    public void toggleTriggerRun(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
        } else if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
        }
    }

    public Trigger.TriggerState getTriggerState(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return null;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        return state;
    }

    public void resumeTrigger(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
        }
    }

    public void pauseTrigger(String triggerName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        TriggerKey key = new TriggerKey(triggerName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
        }
    }

    public void executeJob(String jobName) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        this.scheduler.triggerJob(key);
    }

    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.standby();
    }

    public boolean isStarted() throws SchedulerException {
        return this.scheduler.isStarted();
    }

    public boolean isInStandbyMode() throws SchedulerException {
        return this.scheduler.isInStandbyMode();
    }

    static {
        mapWeek.put("MON", "\u661f\u671f\u4e00");
        mapWeek.put("TUE", "\u661f\u671f\u4e8c");
        mapWeek.put("WED", "\u661f\u671f\u4e09");
        mapWeek.put("THU", "\u661f\u671f\u56db");
        mapWeek.put("FRI", "\u661f\u671f\u4e94");
        mapWeek.put("SAT", "\u661f\u671f\u516d");
        mapWeek.put("SUN", "\u661f\u671f\u65e5");
    }
}

