package com.artfess.file.persistence.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.FlowUploadProperties;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.dao.FlowUploadPropertiesDao;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 
 * <pre> 
 * 描述：流程附件上传配置 处理实现类
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-06-01 20:53:49
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("flowUploadPropertiesManager")
public class FlowUploadPropertiesManagerImpl extends BaseManagerImpl<FlowUploadPropertiesDao, FlowUploadProperties> implements FlowUploadPropertiesManager{

	@Override
	public FlowUploadPropertiesStorageDTO getByFlowKey(String flowKey) {
		List<FlowUploadPropertiesStorageDTO> list = baseMapper.getByFlowKey(flowKey);
		if(BeanUtils.isNotEmpty(list)){
			return list.get(0);
		}
		return null;
	}

	@Override
	public FlowUploadPropertiesStorageDTO getById(String id) {
		List<FlowUploadPropertiesStorageDTO> list = baseMapper.getById(id);
		if(BeanUtils.isNotEmpty(list)){
			return list.get(0);
		}
		return null;
	}

}
