package com.artfess.file.service;

import com.artfess.base.attachment.Attachment;
import com.artfess.file.model.FileType;
import com.artfess.file.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by kl on 2018/1/17.
 * Content :
 */
@Service
public class FilePreviewFactory {

    @Autowired
    FileUtils fileUtils;

    @Autowired
    ApplicationContext context;

    public FilePreview get(Attachment attachment) {
        Map<String, FilePreview> filePreviewMap = context.getBeansOfType(FilePreview.class);
        FileType type=fileUtils.typeFromUrl(attachment.getExtensionName());
        return filePreviewMap.get(type.getInstanceName());
    }
}
