package com.artfess.file.util;


import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.sysConfig.util.SysPropertyUtil;

import javax.servlet.ServletContext;
import java.io.File;
import java.util.Calendar;

/**
 * 附件工具类
 * @company 阿特菲斯信息技术有限公司
 * @author:lj
 * @date:2018年6月15日
 */
public class AppFileUtil {
	/**
	 * 获取系统属性中的文件存储路径
	 * @return
	 */
	public static String getAttachPath() {
		return SysPropertyUtil.getByAlias("file.upload", "D:\\x7\\file");
	}


	/**
	 * 系统参数中获取文件存放的类型
	 * @author xcx
	 * @version 创建时间：2013-12-27  下午3:53:20
	 * @return
	 */
	public static String getSaveType(String propertiesId) {
		if(StringUtil.isNotEmpty(propertiesId)){
			FlowUploadPropertiesManager uploadPropertiesManager = AppUtil.getBean(FlowUploadPropertiesManager.class);
			FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
			if(BeanUtils.isEmpty(uploadProperties)){
				uploadProperties = uploadPropertiesManager.getByFlowKey(propertiesId);
			}
			if(BeanUtils.isNotEmpty(uploadProperties)){
				return uploadProperties.getUploadType();
			}
		}
		return SysPropertyUtil.getByAlias("file.saveType", DefaultFile.SAVE_TYPE_DTABASE);
	}

	/**
	 * 系统参数中获取文件存放的类型
	 * @author xcx
	 * @version 创建时间：2013-12-27  下午3:53:20
	 * @returns
	 */
	public static String getSaveTypeByStoage(String stoageId) {
		if(StringUtil.isNotEmpty(stoageId)){
			FileStorageManager fileStorageManager = AppUtil.getBean(FileStorageManager.class);
			FileStorage fileStorage = fileStorageManager.get(stoageId);
			if(BeanUtils.isNotEmpty(fileStorage)){
				return fileStorage.getUploadType();
			}
		}
		return SysPropertyUtil.getByAlias("file.saveType", DefaultFile.SAVE_TYPE_DTABASE);
	}

	/**
	 * 系统参数获取文件存放的类型
	 * @author xcx
	 * @version 创建时间：2013-12-27  下午3:53:20
	 * @return
	 */
	public static String getFileSaveTypeByConfig(String code) {
		if(StringUtil.isNotEmpty(code)){
			FileConfigManager fileConfigManager = AppUtil.getBean(FileConfigManager.class);
			FileStorageConfigDTO fileStorageConfig = fileConfigManager.getFileConfigByCode(code);

			if(BeanUtils.isNotEmpty(fileStorageConfig)){
				return fileStorageConfig.getUploadType();
			}
		}
		return SysPropertyUtil.getByAlias("file.saveType", DefaultFile.SAVE_TYPE_DTABASE);
	}

	/**
	 * 创建文件目录
	 *            文件名称
	 * @return 文件的完整目录/year/tenant_id_/month/account
	 */
	public static String createFileMkdirs(String tempPath) {
		BaseContext baseContext = AppUtil.getBean(BaseContext.class);
		String tenantId = baseContext.getCurrentTenantId();
		Calendar cal = Calendar.getInstance();
		Integer year = cal.get(Calendar.YEAR); // 当前年份
		Integer month = cal.get(Calendar.MONTH) + 1; // 当前月份
		File one = new File(File.separator +  year + File.separator + tenantId + File.separator + month  + File.separator + tempPath +  File.separator);
		if (!one.exists()) {
			one.mkdirs();
		}
		return one.getPath();
	}

	/**
	 * 系统参数获取文件上传大小（MB）
	 * @author xcx
	 * @version 创建时间：2013-12-27  下午3:53:20
	 * @return
	 */
	public static Double getFileSaveSizeByConfig(String code) {
		if(StringUtil.isNotEmpty(code)){
			FileConfigManager fileConfigManager = AppUtil.getBean(FileConfigManager.class);
			FileStorageConfigDTO fileStorageConfig = fileConfigManager.getFileConfigByCode(code);

			if(BeanUtils.isNotEmpty(fileStorageConfig)){
				return fileStorageConfig.getAllowSize();
			}
		}
		String fileSize =  SysPropertyUtil.getByAlias("file.size", "50");
		return Double.parseDouble(fileSize);
	}


	/**
	 * 创建文件目录
	 *            文件名称
	 * @return 文件的完整目录/year/tenant_id_/month/account
	 */
	public static String createFilePath(String tempPath, String fileName) {
		BaseContext baseContext = AppUtil.getBean(BaseContext.class);
		String tenantId = baseContext.getCurrentTenantId();
		Calendar cal = Calendar.getInstance();
		Integer year = cal.get(Calendar.YEAR); // 当前年份
		Integer month = cal.get(Calendar.MONTH) + 1; // 当前月份
		File one = new File(File.separator +  year + File.separator + tenantId + File.separator + month  + File.separator + tempPath +  File.separator);
		if (!one.exists()) {
			one.mkdirs();
		}
		return one.getPath() + File.separator + fileName;
	}
	/**
	 * 配置文件中获取文件上传路径
	 * 如果为空则采用默认路径/attachFiles/temp
	 * 这个路径返回没有/或\结尾。
	 *
	 * @author hjx
	 * @version 创建时间：2013-11-4  下午3:46:28
	 * @return
	 */
	public static String getBasePath() {
		String attachPath=getAttachPath();
		if (StringUtil.isEmpty(attachPath)) {
			attachPath = AppFileUtil.getRealPath("/attachFiles/temp");
		}
		attachPath=StringUtil.trimSufffix(attachPath, "\\") ;
		attachPath=StringUtil.trimSufffix(attachPath, "/") ;

		return attachPath;
	}

	public static String createPath(String tempPath, String fileName) {
		File one = new File(tempPath);
		if (!one.exists()) {
			one.mkdirs();
		}
		return one.getPath() + File.separator + fileName;
	}

	private static ServletContext servletContext;


	/**
	 *
	 * @param _servletContext
	 */
	public static void init(ServletContext _servletContext)
	{
		servletContext=_servletContext;
	}

	/**
	 * 在web环境中根据web页面的路径获取对应页面的绝对路径。
	 * @param path
	 * @return
	 */
	public static String getRealPath(String path){
		return servletContext.getRealPath(path);
	}

}
