package com.artfess.bpm.plugin.task.startnewflow.context;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.plugin.core.context.AbstractBpmTaskPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.task.startnewflow.def.StartNewFlowPluginDef;
import com.artfess.bpm.plugin.task.startnewflow.entity.StartConfig;
import com.artfess.bpm.plugin.task.startnewflow.entity.StartNewFlowConfig;
import com.artfess.bpm.plugin.task.startnewflow.plugin.StartNewFlowPlugin;
import com.fasterxml.jackson.core.type.TypeReference;
import org.w3c.dom.Element;

import javax.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;

/**
 * 自动发起新流程插件上下文
 * @author co
 *
 */
public class StartNewFlowPluginContext extends AbstractBpmTaskPluginContext {

	/**
	 *
	 */
	private static final long serialVersionUID = 269958940565457305L;



	public List<EventType> getEventTypes() {
		List<EventType> list=new ArrayList<EventType>();
		list.add(EventType.TASK_COMPLETE_EVENT);
		return list;
	}

	@SuppressWarnings("rawtypes")
	public Class<? extends RunTimePlugin> getPluginClass() {
		return StartNewFlowPlugin.class;
	}


	@Override
	public String getPluginXml() {
		StartNewFlowPluginDef pluginDef=(StartNewFlowPluginDef) this.getBpmPluginDef();
		String xml = "";
		try {
			if(BeanUtils.isEmpty(pluginDef.getStartConfigList()))return xml;
			xml = JAXBUtil.marshall(pluginDef.getStartNewFlowConfig(), StartNewFlowConfig.class);
			xml = xml.replace("encoding=\"utf-8\"", "encoding=\"UTF-8\"");
			xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n", "");
		} catch (JAXBException e) {
			e.printStackTrace();
		}
		return xml;
	}

	@Override
	public String getJson() throws Exception {
		StartNewFlowPluginDef pluginDef=(StartNewFlowPluginDef) this.getBpmPluginDef();
		return JsonUtil.toJson(pluginDef.getStartConfigList());
	}



	@Override
	protected BpmPluginDef parseJson(String pluginJson) throws Exception {
		StartNewFlowPluginDef def =new StartNewFlowPluginDef();
		List<StartConfig> list = JsonUtil.toBean(pluginJson, new TypeReference<List<StartConfig>>() {});
		def.setStartConfigList(list);
		return def;
	}

	@Override
	protected BpmPluginDef parseElement(Element element) {
		String xml = XmlUtil.getXML(element);
		StartNewFlowPluginDef def = new  StartNewFlowPluginDef();
		 try {
			 StartNewFlowConfig startConfigs = (StartNewFlowConfig) JAXBUtil.unmarshall(xml,StartNewFlowConfig.class);
			def.setStartConfigList(startConfigs.getStartConfig());
			return def;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}



	@Override
	public String getTitle() {
		return "自动触发新流程";
	}

	@Override
	public int getOrder() {
		return 1;
	}

}
