package com.artfess.uc.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

/**
* uc_shift_rule
* <pre>
* 描述：轮班规则 实体对象
* 构建组：x7
* 作者:qiuxd
* 邮箱:qiuxd@jee-soft.cn
* 日期:2020-08-04 16:07:34
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("uc_shift_rule")
@ApiModel(value = "ShiftRule",description = "轮班规则")
public class ShiftRule extends UcBaseModel<ShiftRule>{

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键")
   protected String id;

   @XmlAttribute(name = "name")
   @TableField("NAME_")
   @ApiModelProperty(value="名称")
   protected String name;

   @XmlAttribute(name = "key")
   @TableField("KEY_")
   @ApiModelProperty(value="KEY")
   protected String key;

   @XmlAttribute(name = "desc")
   @TableField("DESC_")
   @ApiModelProperty(value="描述")
   protected String desc;

   @XmlAttribute(name = "rule")
   @TableField("RULE_")
   @ApiModelProperty(value="规则")
   protected String rule;

   @TableField("HOLIDAY_ID_")
   @ApiModelProperty("节假日ID")
   protected String holidayId;


   public void setId(String id) {
       this.id = id;
   }

   /**
    * 返回 主键
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setName(String name) {
       this.name = name;
   }

   /**
    * 返回 名称
    * @return
    */
   public String getName() {
       return this.name;
   }
   public void setKey(String key) {
       this.key = key;
   }

   /**
    * 返回 KEY
    * @return
    */
   public String getKey() {
       return this.key;
   }
   public void setDesc(String desc) {
       this.desc = desc;
   }

   /**
    * 返回 描述
    * @return
    */
   public String getDesc() {
       return this.desc;
   }
   public void setRule(String rule) {
       this.rule = rule;
   }

   /**
    * 返回 规则
    * @return
    */
   public String getRule() {
       return this.rule;
   }

    public String getHolidayId() {
        return holidayId;
    }

    public void setHolidayId(String holidayId) {
        this.holidayId = holidayId;
    }
   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id)
       .append("name", this.name)
       .append("key", this.key)
       .append("desc", this.desc)
       .append("rule", this.rule)
       .toString();
   }
}
