package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.dao.OperateLogDao;
import com.artfess.uc.manager.OperateLogManager;
import com.artfess.uc.model.OperateLog;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 城市业务逻辑实现类
 *
 */
@Service
public class OperateLogManagerImpl extends BaseManagerImpl<OperateLogDao,OperateLog> implements OperateLogManager {

  

	@Override
    @Transactional
	public CommonResult<String> removeByIdStr(String ids) {
		if (BeanUtils.isNotEmpty(ids)) {
			String[]  idArray=ids.split(",");
			for (String id : idArray) {
				baseMapper.removePhysicalById(id);
			}
		}
		 return new CommonResult<String>(true, "删除日志成功！", "");
	}

	@Override
    @Transactional
	public Integer removePhysical() {
		return baseMapper.removePhysical();
	}

}
