package com.artfess.uc.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.HolidayManager;
import com.artfess.uc.model.Holiday;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：法定节假日 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-03 15:50:17
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/uc/holiday/v1")
@Api(tags="holidayController")
public class HolidayController extends BaseController<HolidayManager,Holiday>{
	@Resource
	HolidayManager holidayManager;
	
    /**
	 * 新增法定节假日
	 * @param holiday
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新法定节假日数据", httpMethod = "POST", notes = "新增,更新法定节假日数据")
	public CommonResult<String> save(@ApiParam(name="holiday",value="法定节假日业务对象", required = true)@RequestBody Holiday holiday) throws Exception{
		String msg = "添加法定节假日成功";
		if(StringUtil.isEmpty(holiday.getId())){
			holidayManager.create(holiday);
		}else{
			holidayManager.update(holiday);
			 msg = "更新法定节假日成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除法定节假日记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除法定节假日记录", httpMethod = "DELETE", notes = "批量删除法定节假日记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		String failRemoveIds = holidayManager.removeWithCheck(ids);
		if (StringUtil.isNotEmpty(failRemoveIds)){
			return new CommonResult<>(false,"id为"+failRemoveIds+"的节假日在轮班中使用，删除失败");
		}
		return new CommonResult<String>(true, "删除成功");
	}
}
