package com.artfess.security.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;

/**
 * 系统功能 --数据库备份管理-备份还原记录表
 *
 * @company wh
 * @author wh
 * @since 2021-04-22
 */
@ApiModel(value="BackupLog对象", description="数据库备份还原记录表")
@TableName("uc_backup_log")
public class BackupLog extends BaseModel<BackupLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "配置ID")
    @TableField("SYSTEM_CONFIG_ID_")
    private String systemConfigId;

    @ApiModelProperty(value = "类型【备份、还原】")
    @TableField("SYSTEM_TYPE_")
    private String systemType;

    @ApiModelProperty(value = "执行结果")
    @TableField("SYSTEM_RESULT_")
    private String systemResult;

    @ApiModelProperty(value = "文件路径")
    @TableField("BACKUP_FILE_")
    private String backupFile;

    @ApiModelProperty(value = "备份时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "还原时间")
    @TableField("REDUCTION_TIME_")
    private LocalDateTime reductionTime;

    @ApiModelProperty(value = "还原人")
    @TableField("REDUCTION_USER")
    private String reductionUser;

    @ApiModelProperty(value = "还原人ID")
    @TableField("REDUCTION_USER_ID")
    private String reductionUserId;

    @ApiModelProperty(value = "还原机构")
    @TableField("REDUCTION_ORG_ID_")
    private String reductionOrgId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSystemConfigId() {
        return systemConfigId;
    }

    public void setSystemConfigId(String systemConfigId) {
        this.systemConfigId = systemConfigId;
    }

    public String getSystemType() {
        return systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public String getSystemResult() {
        return systemResult;
    }

    public void setSystemResult(String systemResult) {
        this.systemResult = systemResult;
    }

    public String getBackupFile() {
        return backupFile;
    }

    public void setBackupFile(String backupFile) {
        this.backupFile = backupFile;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getReductionTime() {
        return reductionTime;
    }

    public void setReductionTime(LocalDateTime reductionTime) {
        this.reductionTime = reductionTime;
    }

    public String getReductionUser() {
        return reductionUser;
    }

    public void setReductionUser(String reductionUser) {
        this.reductionUser = reductionUser;
    }

    public String getReductionUserId() {
        return reductionUserId;
    }

    public void setReductionUserId(String reductionUserId) {
        this.reductionUserId = reductionUserId;
    }

    public String getReductionOrgId() {
        return reductionOrgId;
    }

    public void setReductionOrgId(String reductionOrgId) {
        this.reductionOrgId = reductionOrgId;
    }
}
