package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统行政区划
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysAreas", description = "系统行政区划")
@TableName("portal_sys_areas")
@Data
public class SysAreas extends BaseTreeModel<SysAreas> implements Tree {
    @ApiModelProperty(value = "区域代码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "当前层级,province：省，city：市，country：区/县，town：乡镇，village：村")
    @TableField("LEVEL_CODE_")
    private String levelCode;

    @ApiModelProperty(value = "经度")
    @TableField("LONGITUDE_")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    @TableField("LATITUDE_")
    private Double latitude;

    @ApiModelProperty(value = "名称")
    @TableField("name_")
    private String name;

    @TableField(exist=false)
    protected List<SysAreas> children = new ArrayList<SysAreas>();

    @TableField(exist=false)
    private List<String> levels;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
