package com.artfess.file.persistence.dao;

import com.artfess.file.model.FlowUploadProperties;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * <pre>
 * 描述：流程附件上传配置 DAO接口
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-06-01 20:53:49
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface FlowUploadPropertiesDao extends BaseMapper<FlowUploadProperties> {

	/**
	 * 根据流程key获取附件上传方式
	 * @param flowKey
	 * @return
	 */
	List<FlowUploadPropertiesStorageDTO> getByFlowKey(@Param("flowKey")String flowKey);

	/**
	 * 根据id获取流程附件上传方式
	 * @param id
	 * @return
	 */
	List<FlowUploadPropertiesStorageDTO> getById(@Param("id")String id);
}
