package com.artfess.portal.util.jvm;

import org.springframework.stereotype.Component;

/**
 * @author wh
 * @Package com.scaffold.common.base.jvm
 * @date 2020/5/28 8:48
 * @Description:应用状态监控,包括应用类型,版本,所在的tomcat名以及数据库连接等信息
 */
@Component
public class ApplicationMonitorTask {

    public ApplicationMonitorMessage doRun() {
        return this.createMessage();
    }

    private ApplicationMonitorMessage createMessage() {
        ApplicationMonitorMessage message = new ApplicationMonitorMessage();
        setJVMInfo(message);
        return message;
    }

    private void setJVMInfo(ApplicationMonitorMessage message) {
        try {
            message.setPid(Integer.parseInt(JVMInfoUtils.getPID()));
        } catch (Exception e) {
        }
        message.setJavaVersion(JVMInfoUtils.getJavaVersion());
        message.setRunTime(JVMInfoUtils.getJVMUpTimeMs());
        message.setLoadedClassCount(JVMInfoUtils.getJVMLoadedClassCount());
        message.setUnloadedClassCount(JVMInfoUtils.getJVMUnLoadedClassCount());
        JVMMemoryUtils.JVMMemoryUsage heapMemoryUsage = JVMMemoryUtils.getHeapMemoryUsage();
        if (heapMemoryUsage != null) {
            message.setHeapTotal(heapMemoryUsage.getMax());
            message.setHeapUsed(heapMemoryUsage.getUsed());
            message.setHeapUsedPercent(heapMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage nonHeapMemoryUsage = JVMMemoryUtils.getNonHeapMemoryUsage();
        if (nonHeapMemoryUsage != null) {
            message.setNonHeapTotal(nonHeapMemoryUsage.getMax());
            message.setNonHeapUsed(nonHeapMemoryUsage.getUsed());
            message.setNonHeapUsedPercent(nonHeapMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage edenMemoryUsage = JVMMemoryUtils.getEdenSpaceMemoryUsage();
        if (edenMemoryUsage != null) {
            message.setEdenTotal(edenMemoryUsage.getMax());
            message.setEdenUsed(edenMemoryUsage.getUsed());
            message.setEdenUsedPercent(edenMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage edenPeakMemoryUsage = JVMMemoryUtils.getAndResetEdenSpaceMemoryPeakUsage();
        if (edenPeakMemoryUsage != null) {
            message.setEdenPeakUsedPercent(edenPeakMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage survivorMemoryUsage = JVMMemoryUtils.getSurvivorSpaceMemoryUsage();
        if (survivorMemoryUsage != null) {
            message.setSurvivorTotal(survivorMemoryUsage.getMax());
            message.setSurvivorUsed(survivorMemoryUsage.getUsed());
            message.setSurvivorUsedPercent(survivorMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage survivorPeakMemoryUsage = JVMMemoryUtils.getAndResetSurvivorSpaceMemoryPeakUsage();
        if (survivorPeakMemoryUsage != null) {
            message.setSurvivorPeakUsedPercent(survivorPeakMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage oldGenMemoryUsage = JVMMemoryUtils.getOldGenMemoryUsage();
        if (oldGenMemoryUsage != null) {
            message.setOldTotal(oldGenMemoryUsage.getMax());
            message.setOldUsed(oldGenMemoryUsage.getUsed());
            message.setOldUsedPercent(oldGenMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage oldGenPeakMemoryUsage = JVMMemoryUtils.getAndResetOldGenMemoryPeakUsage();
        if (oldGenPeakMemoryUsage != null) {
            message.setOldPeakUsedPercent(oldGenPeakMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage permGenMemoryUsage = JVMMemoryUtils.getPermGenMemoryUsage();
        if (permGenMemoryUsage != null) {
            message.setPermTotal(permGenMemoryUsage.getMax());
            message.setPermUsed(permGenMemoryUsage.getUsed());
            message.setPermUsedPercent(permGenMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage permGenPeakMemoryUsage = JVMMemoryUtils.getAndResetPermGenMemoryPeakUsage();
        if (permGenPeakMemoryUsage != null) {
            message.setPermPeakUsedPercent(permGenPeakMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage codeCacheGenMemoryUsage = JVMMemoryUtils.getCodeCacheMemoryUsage();
        if (codeCacheGenMemoryUsage != null) {
            message.setCodeCacheTotal(codeCacheGenMemoryUsage.getMax());
            message.setCodeCacheUsed(codeCacheGenMemoryUsage.getUsed());
            message.setCodeCacheUsedPercent(codeCacheGenMemoryUsage.getUsedPercent());
        }
        JVMMemoryUtils.JVMMemoryUsage codeCacheGenPeakMemoryUsage = JVMMemoryUtils.getAndResetCodeCacheMemoryPeakUsage();
        if (codeCacheGenPeakMemoryUsage != null) {
            message.setCodeCachePeakUsedPercent(codeCacheGenPeakMemoryUsage.getUsedPercent());
        }

        message.setYgcName(JVMGCUtils.getYoungGCName());
        message.setYgc(JVMGCUtils.getYoungGCCollectionCount());
        message.setYgcTime(JVMGCUtils.getYoungGCCollectionTime());
        message.setFgcName(JVMGCUtils.getFullGCName());
        message.setFgc(JVMGCUtils.getFullGCCollectionCount());
        message.setFgcTime(JVMGCUtils.getFullGCCollectionTime());

        message.setThreadCount(JVMThreadUtils.getThreadCount());
        message.setThreadPeakCount(JVMThreadUtils.getAndResetPeakThreadCount());
        message.setUserThreadCount(message.getThreadCount() - JVMThreadUtils.getDaemonThreadCount());
        message.setDeadLockedThreadCount(JVMThreadUtils.getDeadLockedThreadCount());
    }

}
