package com.artfess.portal.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 *
 * 新闻通知公告
 * @company 阿特菲斯信息技术有限公司
 * @author 赵祥云
 * @since 2020-07-03
 */
@TableName("PORTAL_NEWS_NOTICE_")
@ApiModel(value="PortalNewsNotice对象", description="")
public class PortalNewsNotice extends BaseModel<PortalNewsNotice> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所属分类ID")
    @TableField("CLASSIFY_ID_")
    private String classifyId;

    @ApiModelProperty(value = "所属分类NAME")
    @TableField("CLASSIFY_NAME_")
    private String classifyName;

    @ApiModelProperty(value = "所属分类路径")
    @TableField("CLASSIFY_PATH_")
    private String classifyPath;

    @ApiModelProperty(value = "标题")
    @TableField("TITLE_")
    private String title;

    @ApiModelProperty(value = "是否外部链接(true为是,false为不是)")
    @TableField("IS_URL_")
    private String isUrl;

    @ApiModelProperty(value = "内容URL")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "过期时间")
    @TableField("END_TIME_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "轮播展示图片")
    @TableField("ROTATING_DISPLAY_PICTURES_")
    private String rotatingDisplayPictures;

    @ApiModelProperty(value = "标题描述")
    @TableField("TITLE_DESCRIPTION_")
    private String titleDescription;

    @ApiModelProperty(value = "页面嵌套高度")
    @TableField("PAGE_HEIGHT_")
    private String pageHeight;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value="CREATE_TIME_", fill=FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    @TableField(value="CREATE_BY_", fill=FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(value = "更新时间")
    @TableField(value="UPDATE_TIME_", fill=FieldFill.UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "更新人")
    @TableField(value="UPDATE_BY_", fill=FieldFill.UPDATE)
    private String updateBy;

    @ApiModelProperty(value = "所属类型(1为轮播图,2为新闻公告)")
    @TableField("TYPE_")
    private BigDecimal type;

    @ApiModelProperty(value = "图标")
    @TableField("ICON_")
    private String icon;


    @ApiModelProperty(value = "附件")
    @TableField("FILE_")
    private String file;

    @ApiModelProperty(value = "起草人")
    @TableField("DRAFTER_")
    private String drafter;


    @ApiModelProperty(value = "创建人姓名")
    @TableField(exist=false)
    private String createByName;

    @ApiModelProperty(value = "更新人姓名")
    @TableField(exist=false)
    private String updateByName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}



	public String getDrafter() {
		return drafter;
	}

	public void setDrafter(String drafter) {
		this.drafter = drafter;
	}

	public String getFile() {
		return file;
	}

	public void setFile(String file) {
		this.file = file;
	}

	public String getCreateByName() {
		return createByName;
	}

	public void setCreateByName(String createByName) {
		this.createByName = createByName;
	}

	public String getUpdateByName() {
		return updateByName;
	}

	public void setUpdateByName(String updateByName) {
		this.updateByName = updateByName;
	}

	public String getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(String classifyId) {
        this.classifyId = classifyId;
    }
    public String getClassifyName() {
        return classifyName;
    }

    public void setClassifyName(String classifyName) {
        this.classifyName = classifyName;
    }
    public String getClassifyPath() {
        return classifyPath;
    }

    public void setClassifyPath(String classifyPath) {
        this.classifyPath = classifyPath;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getIsUrl() {
        return isUrl;
    }

    public void setIsUrl(String isUrl) {
        this.isUrl = isUrl;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }
    public String getRotatingDisplayPictures() {
        return rotatingDisplayPictures;
    }

    public void setRotatingDisplayPictures(String rotatingDisplayPictures) {
        this.rotatingDisplayPictures = rotatingDisplayPictures;
    }
    public String getTitleDescription() {
        return titleDescription;
    }

    public void setTitleDescription(String titleDescription) {
        this.titleDescription = titleDescription;
    }
    public String getPageHeight() {
        return pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public BigDecimal getType() {
        return type;
    }

    public void setType(BigDecimal type) {
        this.type = type;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PortalNewsNotice{" +
            "id=" + id +
            ", classifyId=" + classifyId +
            ", classifyName=" + classifyName +
            ", classifyPath=" + classifyPath +
            ", title=" + title +
            ", isUrl=" + isUrl +
            ", url=" + url +
            ", content=" + content +
            ", sn=" + sn +
            ", endTime=" + endTime +
            ", rotatingDisplayPictures=" + rotatingDisplayPictures +
            ", titleDescription=" + titleDescription +
            ", pageHeight=" + pageHeight +
            ", tenantId=" + tenantId +
            ", createTime=" + createTime +
            ", createBy=" + createBy +
            ", updateTime=" + updateTime +
            ", updateBy=" + updateBy +
            ", type=" + type +
        "}";
    }
}
