package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 训练类别
 */
@Getter
public enum TrainTypeEnum {
    jcgtxl("1", "基础共同训练"),

    zygtxl("2", "专业共同训练"),

    gqxl("3", "岗前训练"),

    gwxl("4", "岗位训练"),


    ;

    TrainTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        TrainTypeEnum[] values = values();
        for (TrainTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        TrainTypeEnum[] values = values();
        for (TrainTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
