package com.artfess.form.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.constant.BoConstants;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.form.param.GenerateExpandParam;
import com.artfess.form.param.TemplateEntParam;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 生成表单模板工具类
 *
 * @author ray。
 */
public class GenerateExpandUtil {

    public static String LAYOUT_GRID = "grid";
    public static String LAYOUT_TABLE = "table";
    public static String LAYOUT_DIV = "div";

    public static ArrayNode getLayoutList(GenerateExpandParam params, List<BoDef> defList) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        Map<String, TemplateEntParam> templateMap = new HashMap<String, TemplateEntParam>();
        for (TemplateEntParam entParam : params.getEntList()) {
            templateMap.put(entParam.getAlias(), entParam);
        }
        for (BoDef boDef : defList) {
            //处理主表字段
            BoEnt mainEnt = boDef.getBoEnt();
            List<BoAttribute> mainAttr = mainEnt.getBoAttrList();
            TemplateEntParam mainParam = templateMap.get(mainEnt.getName());
            int mainColumn = mainParam.getColumn();
            int span = 24 / mainColumn;
            String mainTemplate = mainParam.getTemplate();
            if (BeanUtils.isNotEmpty(mainAttr)) {
                mainAttr = getActiveAttr(mainAttr);
                ArrayNode columns = null;
                if (LAYOUT_GRID.equals(mainTemplate)) {
                    for (int i = 0; i < mainAttr.size(); i++) {
                        int index = i + 1;
                        if (columns == null) {
                            columns = JsonUtil.getMapper().createArrayNode();
                        }
                        ObjectNode fieldNode = getFieldNode(boDef, null, mainEnt, mainAttr.get(i), "main", mainTemplate);
                        ObjectNode colItem = getColItem(fieldNode, span);
                        columns.add(colItem);
                        if (index % mainColumn == 0) {
                            ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "", mainEnt);
                            array.add(gradNode);
                            columns = null;
                        } else if (i == mainAttr.size() - 1 && columns != null) {
                            addLackGrad(columns, span, mainColumn - columns.size());
                            ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "", mainEnt);
                            array.add(gradNode);
                            columns = null;
                        }
                    }
                } else if (LAYOUT_TABLE.equals(mainTemplate)) {
                    columns = JsonUtil.getMapper().createArrayNode();
                    ArrayNode colsNodes = null;
                    for (int i = 0; i < mainAttr.size(); i++) {
                        int index = i + 1;
                        if (colsNodes == null) {
                            colsNodes = JsonUtil.getMapper().createArrayNode();
                        }
                        ObjectNode fieldNode = getFieldNode(boDef, null, mainEnt, mainAttr.get(i), "main", mainTemplate);
                        ArrayNode listNode = JsonUtil.getMapper().createArrayNode();
                        listNode.add(fieldNode);
                        ObjectNode colTd = JsonUtil.getMapper().createObjectNode();
                        colTd.put("colspan", 1);
                        colTd.set("list", listNode);
                        colsNodes.add(colTd);
                        if (index % mainColumn == 0) {
                            ObjectNode colsNode = JsonUtil.getMapper().createObjectNode();
                            colsNode.set("cols", colsNodes);
                            columns.add(colsNode);
                            colsNodes = null;
                        } else if (i == mainAttr.size() - 1 && columns != null) {
                            addLackTd(colsNodes, mainColumn - colsNodes.size());
                            ObjectNode colsNode = JsonUtil.getMapper().createObjectNode();
                            colsNode.set("cols", colsNodes);
                            columns.add(colsNode);
                        }
                    }
                    ObjectNode tableNode = getLayoutNode(columns, LAYOUT_TABLE, "", mainEnt);
                    array.add(tableNode);
                }
            }
            //处理子表字段
            List<BoEnt> subEnts = mainEnt.getChildEntList();
            for (BoEnt subEnt : subEnts) {
                TemplateEntParam subParam = templateMap.get(subEnt.getName());
                List<BoAttribute> subAttr = subEnt.getBoAttrList();
                ArrayNode fieldList = JsonUtil.getMapper().createArrayNode();
                if (BeanUtils.isNotEmpty(subAttr)) {
                    subAttr = getActiveAttr(subAttr);
                    if (LAYOUT_TABLE.equals(subParam.getTemplate())) {
                        for (BoAttribute subAttribute : subAttr) {
                            ObjectNode fieldNode = getFieldNode(boDef, mainEnt, subEnt, subAttribute, "sub", subParam.getTemplate());
                            fieldList.add(fieldNode);
                        }
                        ObjectNode subTableNode = getSubTableNode(boDef.getAlias(), subEnt.getRelation(), subEnt.getName(), subEnt.getDesc(), fieldList, LAYOUT_TABLE);
                        //处理孙表字段
                        List<BoEnt> sunEnts = subEnt.getChildEntList();
                        if (BeanUtils.isNotEmpty(sunEnts)) {
                            addSunLayout(fieldList, boDef, subEnt, sunEnts, templateMap);
                        }
                        array.add(subTableNode);
                    } else if (LAYOUT_DIV.equals(subParam.getTemplate())) {
                        ArrayNode columns = null;
                        int subColumn = subParam.getColumn();
                        int subSpan = 24 / subColumn;
                        for (int i = 0; i < subAttr.size(); i++) {
                            int index = i + 1;
                            if (columns == null) {
                                columns = JsonUtil.getMapper().createArrayNode();
                            }
                            ObjectNode fieldNode = getFieldNode(boDef, mainEnt, subEnt, subAttr.get(i), "sub", mainTemplate);
                            ObjectNode colItem = getColItem(fieldNode, subSpan);
                            columns.add(colItem);
                            if (index % subColumn == 0) {
                                ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "sub", subEnt);
                                fieldList.add(gradNode);
                                columns = null;
                            } else if (i == subAttr.size() - 1 && columns != null) {
                                addLackGrad(columns, subSpan, subColumn - columns.size());
                                ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "sub", subEnt);
                                fieldList.add(gradNode);
                                columns = null;
                            }
                        }
                        //处理孙表字段
                        List<BoEnt> sunEnts = subEnt.getChildEntList();
                        if (BeanUtils.isNotEmpty(sunEnts)) {
                            addSunLayout(fieldList, boDef, subEnt, sunEnts, templateMap);
                        }
                        ObjectNode subTableNode = getSubTableNode(boDef.getAlias(), subEnt.getRelation(), subEnt.getName(), subEnt.getDesc(), fieldList, LAYOUT_DIV);
                        array.add(subTableNode);
                    }
                }

            }
        }
        return array;
    }

    /**
     * 过滤已删除的bo字段
     *
     * @param attrs
     * @return
     */
    private static List<BoAttribute> getActiveAttr(List<BoAttribute> attrs) {
        List<BoAttribute> activeAttrs = new ArrayList<BoAttribute>();
        if (BeanUtils.isNotEmpty(attrs)) {
            for (BoAttribute attr : attrs) {
                if (!"hide".equals(attr.getStatus())) {
                    activeAttrs.add(attr);
                }
            }
        }
        return activeAttrs;
    }

    private static void addSunLayout(ArrayNode fieldList, BoDef boDef, BoEnt subEnt, List<BoEnt> sunEnts, Map<String, TemplateEntParam> templateMap) throws Exception {
        for (BoEnt sunEnt : sunEnts) {
            TemplateEntParam sunParam = templateMap.get(sunEnt.getName());
            ArrayNode sunFieldList = JsonUtil.getMapper().createArrayNode();
            List<BoAttribute> sunAttr = sunEnt.getBoAttrList();
            sunAttr = getActiveAttr(sunAttr);
            if (LAYOUT_TABLE.equals(sunParam.getTemplate())) {
                for (BoAttribute sunAttribute : sunAttr) {
                    ObjectNode fieldNode = getFieldNode(boDef, subEnt, sunEnt, sunAttribute, "sun", sunParam.getTemplate());
                    sunFieldList.add(fieldNode);
                }
            } else {
                ArrayNode columns = null;
                int sunColumn = sunParam.getColumn();
                int sunSpan = 24 / sunColumn;
                for (int i = 0; i < sunAttr.size(); i++) {
                    int index = i + 1;
                    if (columns == null) {
                        columns = JsonUtil.getMapper().createArrayNode();
                    }
                    ObjectNode fieldNode = getFieldNode(boDef, subEnt, sunEnt, sunAttr.get(i), "sun", sunParam.getTemplate());
                    ObjectNode colItem = getColItem(fieldNode, sunSpan);
                    columns.add(colItem);
                    if (index % sunColumn == 0) {
                        ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "sun", sunEnt);
                        sunFieldList.add(gradNode);
                        columns = null;
                    } else if (i == sunAttr.size() - 1 && columns != null) {
                        addLackGrad(columns, sunSpan, sunColumn - columns.size());
                        ObjectNode gradNode = getLayoutNode(columns, LAYOUT_GRID, "sun", sunEnt);
                        sunFieldList.add(gradNode);
                        columns = null;
                    }
                }
            }
            ObjectNode sunTableNode = getSunTableNode(boDef.getAlias(), sunEnt.getRelation(), subEnt.getName(), sunEnt.getName(), sunEnt.getDesc(), sunFieldList, sunParam.getTemplate());
            fieldList.add(sunTableNode);
        }
    }

    /**
     * 补齐缺少的栅格对象
     *
     * @param columns
     * @param span
     */
    private static void addLackGrad(ArrayNode columns, int span, int size) {
        if (size > 0) {
            for (int i = 0; i < size; i++) {
                ObjectNode field = JsonUtil.getMapper().createObjectNode();
                field.put("span", span);
                field.set("list", JsonUtil.getMapper().createArrayNode());
                columns.add(field);
            }
        }
    }

    /**
     * 补齐缺少的td对象
     *
     * @param columns
     * @param span
     */
    private static void addLackTd(ArrayNode colsNodes, int size) {
        if (size > 0) {
            ObjectNode field = JsonUtil.getMapper().createObjectNode();
            field.put("colspan", size);
            field.set("list", JsonUtil.getMapper().createArrayNode());
            colsNodes.add(field);
        }
    }

    /**
     * 获取table子表布局控件
     *
     * @return
     */
    private static ObjectNode getSubTableNode(String defAlias, String relation, String name, String desc, ArrayNode fieldList, String layoutType) {
        String path = defAlias + ".sub_" + name;
        ObjectNode subtableNode = JsonUtil.getMapper().createObjectNode();
        subtableNode.put("ctrlType", LAYOUT_TABLE.equals(layoutType) ? "subtable" : "subDiv");
        subtableNode.put("name", name);
        subtableNode.put("desc", desc);
        subtableNode.put("icon", "icon-table2");
        subtableNode.put("isLayout", true);
        subtableNode.put("customHeader", "");
        subtableNode.put("boSubEntity", name);
        subtableNode.set("list", fieldList);
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("showLabel", true);
        optionsNode.put("boSubEntity", name);
        optionsNode.put("subTablePath", path);
        optionsNode.put("relation", relation);
        optionsNode.put("subDivTablePath", path);
        subtableNode.set("options", optionsNode);
        ObjectNode customQueryNode = JsonUtil.getMapper().createObjectNode();
        customQueryNode.put("isUse", false);
        customQueryNode.set("resultfield", JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customQuery", customQueryNode);
        ObjectNode customDialogNode = JsonUtil.getMapper().createObjectNode();
        customDialogNode.put("name", "子表回填");
        customDialogNode.put("icon", "");
        ObjectNode custDialogNode = JsonUtil.getMapper().createObjectNode();
        custDialogNode.set("conditions", JsonUtil.getMapper().createArrayNode());
        custDialogNode.set("mappingConf", JsonUtil.getMapper().createArrayNode());
        customDialogNode.set("custDialog", custDialogNode);
        ObjectNode orgConfigNode = JsonUtil.getMapper().createObjectNode();
        orgConfigNode.put("name", "");
        orgConfigNode.put("code", "");
        orgConfigNode.put("id", "");
        customDialogNode.set("orgConfig", orgConfigNode);
        customDialogNode.set("resultField", JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customDialogjson", customDialogNode);
        subtableNode.put("subtableBackfill", false);
        subtableNode.put("initTemplateData", false);
        subtableNode.put("initTemplateDataType", "empty");
        subtableNode.put("key", getRandomKey());
        return subtableNode;
    }

    /**
     * 获取table子表布局控件
     *
     * @return
     */
    private static ObjectNode getSunTableNode(String defAlias, String relation, String subName, String sunName, String desc, ArrayNode fieldList, String layoutType) {
        String path = defAlias + ".sub_" + subName + ".sub_" + sunName;
        ObjectNode subtableNode = JsonUtil.getMapper().createObjectNode();
        subtableNode.put("ctrlType", LAYOUT_TABLE.equals(layoutType) ? "suntable" : "sunDiv");
        subtableNode.put("name", sunName);
        subtableNode.put("desc", desc);
        subtableNode.put("icon", "icon-table2");
        subtableNode.put("isLayout", true);
        subtableNode.put("customHeader", "");
        subtableNode.set("list", fieldList);
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("showLabel", true);
        optionsNode.put("boSubEntity", sunName);
        optionsNode.put("subTablePath", path);
        optionsNode.put("relation", relation);
        subtableNode.set("options", optionsNode);
        ObjectNode customDialogNode = JsonUtil.getMapper().createObjectNode();
        customDialogNode.put("name", "孙表回填");
        customDialogNode.put("icon", "");
        ObjectNode custDialogNode = JsonUtil.getMapper().createObjectNode();
        custDialogNode.set("conditions", JsonUtil.getMapper().createArrayNode());
        custDialogNode.set("mappingConf", JsonUtil.getMapper().createArrayNode());
        customDialogNode.set("custDialog", custDialogNode);
        ObjectNode orgConfigNode = JsonUtil.getMapper().createObjectNode();
        orgConfigNode.put("name", "");
        orgConfigNode.put("code", "");
        orgConfigNode.put("id", "");
        customDialogNode.set("orgConfig", orgConfigNode);
        customDialogNode.set("resultField", JsonUtil.getMapper().createArrayNode());
        subtableNode.set("customDialogjson", customDialogNode);
        subtableNode.put("subtableBackfill", false);
        subtableNode.put("boSubEntity", subName);
        subtableNode.put("parentNodeType", "sun");
        subtableNode.put("key", getRandomKey());
        return subtableNode;
    }

    /**
     * 获取栅格布局控件
     *
     * @return
     */
    private static ObjectNode getLayoutNode(ArrayNode columns, String layoutType, String entType, BoEnt ent) {
        ObjectNode gridNode = JsonUtil.getMapper().createObjectNode();
        gridNode.put("name", "");
        gridNode.put("isLayout", true);
        gridNode.put("ctrlType", layoutType);
        gridNode.put("icon", "icon-grid");
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        optionsNode.put("gutter", 0);
        optionsNode.put("justify", "start");
        optionsNode.put("align", "top");
        if (LAYOUT_GRID.equals(layoutType)) {
            gridNode.put("desc", "栅格布局");
            gridNode.set("columns", columns);
            if (StringUtil.isNotEmpty(entType)) {
                gridNode.put("parentNodeType", entType);
                gridNode.put("parentType", "subDiv");
                gridNode.put("boSubEntity", ent.getName());
            }
        } else if (LAYOUT_TABLE.equals(layoutType)) {
            gridNode.put("desc", "表格布局");
            gridNode.set("rows", columns);
            optionsNode.put("lineHeight", 40);
            optionsNode.put("borderColor", "#b5b5b5");
            optionsNode.put("borderWidth", 1);
            optionsNode.put("fontColor", "#808080");
            optionsNode.put("labelWidthType", "percent");
            optionsNode.put("labelWidth", 30);
        }
        gridNode.set("options", optionsNode);
        gridNode.put("key", getRandomKey());
        return gridNode;
    }

    private static ObjectNode getColItem(ObjectNode fieldNode, int span) {
        ObjectNode colItem = JsonUtil.getMapper().createObjectNode();
        ArrayNode colList = JsonUtil.getMapper().createArrayNode();
        colList.add(fieldNode);
        colItem.put("span", span);
        colItem.set("list", colList);
        return colItem;
    }

    /**
     * 返回字段控件属性
     *
     * @return
     * @throws Exception
     */
    public static ObjectNode getFieldNode(BoDef boDef, BoEnt pent, BoEnt ent, BoAttribute attr, String entType, String template) throws Exception {
        ObjectNode fieldNode = JsonUtil.getMapper().createObjectNode();
        String ctrlType = "input";
        String dataType = attr.getDataType();
        fieldNode.put("icon", "icon-single");
        switch (dataType) {
            case "number":
                ctrlType = "number";
                break;
            case "clob":
                ctrlType = "textarea";
                break;
            case "date":
                ctrlType = "date";
                fieldNode.put("icon", "icon-date");
                break;
        }
        String path = boDef.getAlias() + "." + attr.getName();
        if ("sub".equals(entType)) {
            path = "item." + attr.getName();
            fieldNode.put("parentNodeType", "sub");
            fieldNode.put("boSubEntity", ent.getName());
        } else if ("sun".equals(entType)) {
            path = boDef.getAlias() + ".sub_" + pent.getName() + ".sub_" + ent.getName() + "." + attr.getName();
            fieldNode.put("parentNodeType", "sun");
            fieldNode.put("boSubEntity", ent.getName());
        }
        fieldNode.put("ctrlType", ctrlType);
        fieldNode.put("name", attr.getName());
        fieldNode.put("desc", attr.getDesc());
        fieldNode.put("key", getRandomKey());
        fieldNode.put("target", attr.getName());
        fieldNode.put("boDefId", boDef.getId());
        fieldNode.put("boAttrId", attr.getId());
        fieldNode.put("fieldPath", path);
        fieldNode.put("title", attr.getDesc());
        fieldNode.put("entId", attr.getEntId());
        fieldNode.put("boDefAlias", boDef.getAlias());
        fieldNode.put("tableName", ent.getName());
        fieldNode.put("columnType", dataType);
        fieldNode.set("options", getOptionsNode(attr, entType, template));
        return fieldNode;
    }

    private static ObjectNode getOptionsNode(BoAttribute attr, String entType, String template) {
        ObjectNode optionsNode = JsonUtil.getMapper().createObjectNode();
        String dataType = attr.getDataType();
        if ("main".equals(entType) && !"date".equals(dataType)) {
            optionsNode.put("width", "100%");
            optionsNode.put("isWidth", true);
        }
        if ("number".equals(dataType)) {
            optionsNode.put("defaultValue", 0);
            optionsNode.put("min", 0);
            optionsNode.put("max", 99999);
            optionsNode.put("step", 1);
            optionsNode.put("decimalDigits", 2);
            optionsNode.put("maxDecimalDigits", attr.getDecimalLen());
            optionsNode.put("filtercurrency", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("advancedProperty", "inputType|bindPreAndSufFix");
            optionsNode.put("basicsProperty", "number|currency|placeholder|dateCount");
            optionsNode.put("controlsPosition", "");
            optionsNode.put("company", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("filterthousandBit", "");
            optionsNode.put("validateType", "min_value|max_value|confirmed|numeric|between|digits|required|row_unique|frontJSValidate|mobile");
            optionsNode.put("dataType", "number");
        } else {
            optionsNode.put("defaultValue", "");
            optionsNode.put("dataType", "string|text");
            optionsNode.put("validateType", "regex|min|max|required|row_unique|frontJSValidate|backendValidate");
            optionsNode.put("advancedProperty", "isEditor|isInputEdit");
            optionsNode.put("placeholder", "");
            optionsNode.put("basicsProperty", "placeholder");
            if (!"clob".equals(dataType)) {
                optionsNode.put("dataType", "date".equals(dataType) ? "date" : "string|number");
                optionsNode.put("validateType", "confirmed|email|regex|min|max|min_value|max_value|isAfter|isBefore|isStart|isEnd|numeric|between|is|digits|mobile|required|row_unique|alpha_spaces|alpha_dash|alpha_num|alpha|frontJSValidate|backendValidate");
                optionsNode.put("validate", "");
                if ("date".equals(dataType)) {
                    optionsNode.put("readonly", false);
                    optionsNode.put("editable", true);
                    optionsNode.put("clearable", true);
                    optionsNode.put("timestamp", false);
                    optionsNode.put("required", false);
                    optionsNode.put("advancedProperty", "bindPreAndSufFix");
                    optionsNode.put("validateType", "isAfter|isBefore|isStart|isEnd|required|row_unique|frontJSValidate");
                    optionsNode.put("basicsProperty", "date|placeholder");
                    optionsNode.put("type", "date");
                } else {
                    optionsNode.put("advancedProperty", "isInputEdit|isBindIdentity|inputType|bindPreAndSufFix");
                    optionsNode.put("basicsProperty", "input|dateCount|placeholder");
                    optionsNode.put("isCountDate", false);
                    ObjectNode conditionNode = JsonUtil.getMapper().createObjectNode();
                    conditionNode.put("target", "");
                    conditionNode.put("fieldPath", "");
                    conditionNode.put("value", "");
                    optionsNode.set("showCondition", conditionNode);
                    optionsNode.put("isStartDate", "");
                    optionsNode.put("isEndDate", "");
                    optionsNode.put("countFormat", "day");
                    optionsNode.set("bindIdentityjson", JsonUtil.getMapper().createObjectNode());
                    optionsNode.put("isBindPreAndSufFix", false);
                }
            } else {
                optionsNode.put("dataType", "clob");
            }
        }
        ArrayNode validateList = JsonUtil.getMapper().createArrayNode();
        // 建模字段设置必填时添加必填校验
        if (BoConstants.REQUIRED_YES == attr.getIsRequired()) {
            ObjectNode childValidate = JsonUtil.getMapper().createObjectNode();
            childValidate.put("key", "required");
            childValidate.put("name", "*必填");
            validateList.add(childValidate);
            optionsNode.put("validate", "'required'");
        }
        optionsNode.set("validateList", validateList);
        optionsNode.put("disabled", false);
        optionsNode.put("formulasDiyJs", "");
        optionsNode.put("lableColor", "#969799");
        if (!"clob".equals(dataType)) {
            optionsNode.put("mathExp", "");
            ObjectNode fixjsonNode = JsonUtil.getMapper().createObjectNode();
            fixjsonNode.put("preFix", "");
            fixjsonNode.put("sufSix", "");
            optionsNode.set("bindPreAndSufFixjson", fixjsonNode);
        }
        if ("date".equals(dataType)) {
            optionsNode.put("format", attr.getFormat());
            optionsNode.put("inputFormat", attr.getFormat());
        }
        return optionsNode;
    }

    private static String getRandomKey() {
        return String.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"))) + "_" + (int) Math.ceil(Math.random() * 99999);
    }

}
