package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 考生模拟考试记录（人员考试成绩）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamImitateRecord对象", description="考生模拟考试记录（人员考试成绩）")
public class ExamImitateRecord extends BaseModel<ExamImitateRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷基础信息ID")
    @TableField("paper_base_id_")
    private String paperBaseId;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "开考时间")
    @TableField("start_time_")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "交卷时间")
    @TableField("end_time_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "所用时长（默认单位：分钟）")
    @TableField("answer_time_")
    private String answerTime;

    @ApiModelProperty(value = "考试得分")
    @TableField("total_score_")
    private BigDecimal totalScore;

    @ApiModelProperty(value = "考试状态【字典】(1：未开始2：考试中， 3：已交卷)")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "创建人_组织_ID")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人员")
    @TableField("update_by_")
    private String updateBy;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "试卷名称")
    @TableField(exist = false)
    private String paperName;

    @ApiModelProperty(value = "考试时长（分钟）")
    @TableField(exist = false)
    private BigDecimal timeLength;

    @ApiModelProperty(value = "总题目数")
    @TableField(exist = false)
    private Integer totalNumber;

    @ApiModelProperty(value = "总分")
    @TableField(exist = false)
    private BigDecimal score;

}
