package com.artfess.data.vo;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.model.BizTrainMaterial;
import com.artfess.data.model.BizUserTrainPlan;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 年度训练计划
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-09-02
 */
@Data
@ApiModel(value = "YearPlanVo对象", description = "年度训练计划")
public class YearPlanVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "年度", column = "A")
    @ApiModelProperty(value = "年度")
    private String year;

    @Excel(name = "开始时间", column = "B")
    @ApiModelProperty(value = "开始时间")
    private LocalDate startTime;

    @Excel(name = "结束时间", column = "C")
    @ApiModelProperty(value = "结束时间")
    private LocalDate endTime;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "D")
    @ApiModelProperty(value = "单位")
    private String orgName;

    @Excel(name = "专业", column = "G")
    @ApiModelProperty(value = "专业")
    private String majorName;

    @Excel(name = "岗位", column = "F")
    @ApiModelProperty(value = "岗位")
    @TableField("post_")
    private String post;

    @Excel(name = "训练课目", column = "E")
    @ApiModelProperty(value = "训练课目")
    private String subjectName;

    @Excel(name = "训练等级", column = "H")
    @ApiModelProperty(value = "训练等级")
    private String trainLevel;

    @Excel(name = "应训人数（人）", column = "I")
    @ApiModelProperty(value = "应训人数（人）")
    private Long totalNum;


    @Excel(name = "训练时长(h)", column = "J")
    @ApiModelProperty(value = "训练时长(h)")
    private BigDecimal hour;

    @Excel(name = "训练场地", column = "K")
    @ApiModelProperty(value = "训练场地")
    private String spaceName;

    @Excel(name = "教练员", column = "L")
    @ApiModelProperty(value = "教练员")
    private String coachName;

    @Excel(name = "主训员", column = "M")
    @ApiModelProperty(value = "主训员")
    private String mainUserName;

    @Excel(name = "训练方式", column = "N")
    @ApiModelProperty(value = "训练方式【字典】（1：集中组织、2：自行学习）")
    private String way;

    @Excel(name = "训练类别", column = "O")
    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    private String trainType;

    @Excel(name = "训练内容及要求", column = "P")
    @ApiModelProperty(value = "训练内容及要求")
    private String memo;

}
