package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 训练场地数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@FieldRepeat(fields = {"name"}, groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="BizExamSpaceData对象", description="训练场地数据")
public class BizExamSpaceData extends AutoFillModel<BizExamSpaceData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请填写场地名称", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "场地名称", column = "A")
    @ApiModelProperty(value = "场地名称")
    @TableField("name_")
    private String name;

    @Excel(name = "场地类型", column = "B")
    @ApiModelProperty(value = "场地类型【字典】")
    @TableField("type_")
    private String type;

    @NotNull(message = "请选择责任单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "责任单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "责任单位", column = "C")
    @ApiModelProperty(value = "责任单位")
    @TableField("accountability_org_")
    private String accountabilityOrg;

    @Excel(name = "承训规模", column = "D")
    @ApiModelProperty(value = "承训规模")
    @TableField("train_scale_")
    private String trainScale;

    @Excel(name = "配套设施详情", column = "E")
    @ApiModelProperty(value = "配套设施详情")
    @TableField("detail_")
    private String detail;

    @Excel(name = "备注", column = "F")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
