package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 训练计划数据
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-09-02
 */
@Data
@ApiModel(value = "BizExamPlan对象", description = "训练计划数据")
public class BizExamPlan extends AutoFillModel<BizExamPlan> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择总计划", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "总计划id")
    @TableField("general_plan_id_")
    private String generalPlanId;

    @Excel(name = "年度", column = "A")
    @ApiModelProperty(value = "年度")
    @TableField("year_")
    private String year;

    @NotNull(message = "请选择计划类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计划类型【字典】(1:年度、2:阶段、3:月、4:周、5:排班、6:集约、7补训)")
    @TableField("plan_type_")
    private String planType;

    @ApiModelProperty(value = "季度")
    @TableField("quarter_")
    private String quarter;

    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private Integer month;

    @ApiModelProperty(value = "周序号【字典】（1：第一周、2：第二周、3：第三周、4：第四周）")
    @TableField("week_")
    private String week;

    @NotNull(message = "请填写开始时间", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "开始时间")
    @TableField("start_time_")
    private LocalDate startTime;

    @NotNull(message = "请填写结束时间", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "结束时间")
    @TableField("end_time_")
    private LocalDate endTime;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @NotNull(message = "请选择单位", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "单位", column = "B")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @ApiModelProperty(value = "专业id")
    @TableField("major_id_")
    private String majorId;

    @Excel(name = "专业", column = "C")
    @ApiModelProperty(value = "专业")
    @TableField("major_name_")
    private String majorName;

    @Excel(name = "岗位", column = "D")
    @ApiModelProperty(value = "岗位")
    @TableField("post_")
    private String post;

    @ApiModelProperty(value = "岗位ID")
    @TableField("post_id_")
    private String postId;

    @ApiModelProperty(value = "训练课目")
    @TableField("subject_name_")
    private String subjectName;

    @NotNull(message = "请选择训练课目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "训练课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "训练等级", column = "E")
    @ApiModelProperty(value = "训练等级")
    @TableField("train_level_")
    private String trainLevel;

    @ApiModelProperty(value = "应训人数（人）")
    @TableField("total_num_")
    private Long totalNum;

    @ApiModelProperty(value = "已训人数（人）")
    @TableField("reality_num_")
    private Long realityNum;

    @NotNull(message = "请填写训练时长", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "训练时长(h)")
    @TableField("hour_")
    private BigDecimal hour;

    @ApiModelProperty(value = "训练场地id")
    @TableField("space_id_")
    private String spaceId;

    @ApiModelProperty(value = "训练场地")
    @TableField("space_name_")
    private String spaceName;

    @ApiModelProperty(value = "教练员ID")
    @TableField("coach_id_")
    private String coachId;

    @ApiModelProperty(value = "教练员")
    @TableField("coach_name_")
    private String coachName;

    @ApiModelProperty(value = "主训员id")
    @TableField("main_user_id_")
    private String mainUserId;

    @ApiModelProperty(value = "主训员")
    @TableField("main_user_name")
    private String mainUserName;

    @ApiModelProperty(value = "训练方式【字典】（1：集中组织、2：自行学习）")
    @TableField("way_")
    private String way;

    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    @TableField("train_type_")
    private String trainType;

    @ApiModelProperty(value = "训练内容及要求")
    @TableField("train_content_")
    private String trainContent;

    @ApiModelProperty(value = "计划状态(0:待确认、1:执行中、2:已完成、3:未完成)")
    @TableField("plan_status_")
    private String planStatus = "0";


    @Excel(name = "备注", column = "G")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "last_time_", fill = FieldFill.INSERT_UPDATE, select = true)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "参与考生信息")
    @TableField(exist = false)
    private List<BizUserTrainPlan> userTrainPlans;

    @ApiModelProperty(value = "训练使用物资")
    @TableField(exist = false)
    private List<BizTrainMaterial> materials;

    @ApiModelProperty(value = "剩余的时长")
    @TableField(exist = false)
    private BigDecimal remainingDuration;
}
