package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 环境影响数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizEnvironmentalImpactData对象", description="环境影响数据")
public class BizEnvironmentalImpactData extends AutoFillModel<BizEnvironmentalImpactData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @NotNull(message = "请填写单位", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "单位", column = "A")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "测绘地理", column = "B")
    @ApiModelProperty(value = "测绘地理")
    @TableField("mapping_geography_")
    private String mappingGeography;

    @Excel(name = "气象海洋", column = "C")
    @ApiModelProperty(value = "气象海洋")
    @TableField("meteorological_ocean_")
    private String meteorologicalOcean;

    @Excel(name = "气象海洋等战场环境对武器平台能效影响", column = "D")
    @ApiModelProperty(value = "气象海洋等战场环境对武器平台能效影响")
    @TableField("efficiency_impac_t")
    private String efficiencyImpacT;

    @Excel(name = "备注", column = "E")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
