package com.artfess.data.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.vo.TrainReqVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 年度训练计划数据 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
public interface BizExamPlanDao extends BaseMapper<BizExamPlan> {

    List<JSONObject> planStatistical(@Param("userId") String userId);

    List<JSONObject> trainPlanStylolitic(@Param("vo") TrainReqVo reqVo);

    List<JSONObject> orgYearTrainPlan(@Param("vo") TrainReqVo reqVo);

    IPage<BizExamPlan> myTrainPlan(IPage<BizExamPlan> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizExamPlan> convert2Wrapper);

    IPage<BizExamPlan> monthPlanStatistical(IPage<BizExamPlan> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizExamPlan> convert2Wrapper);

    IPage<BizExamPlan> findByPage(IPage<BizExamPlan> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizExamPlan> convert2Wrapper);
}
