package com.artfess.examine.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.PaperStatusEnum;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.vo.JobStatisticalVo;
import com.artfess.examine.vo.PaperAnalysisVo;
import com.artfess.examine.vo.PaperStatisticalVo;
import com.artfess.examine.vo.QuestionAnalysisVo;
import com.artfess.examine.vo.StatisticalReqVo;
import com.google.api.client.util.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 考生线上考试详情 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-10-19
 */
@Slf4j
@RestController
@Api(tags = "统计分析")
@RequestMapping("/exam/statistical")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class StatisticalController {

    @Autowired
    private ExamUserRecordManager userRecordManager;

    @Autowired
    private ExamQuestionsInfoManager questionsInfoManager;


    @PostMapping(value = "/paper", produces = {"application/json; charset=utf-8"})
    @ApiOperation("考试统计")
    public PageList<PaperStatisticalVo> trainingPaperQuery(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamPaperBase> queryFilter) {

        AtomicReference<String> paperStatus = new AtomicReference<>();
        queryFilter.getQuerys().forEach(queryField -> {
            //如果是模拟训练则只能查看自己创建的试卷
            if ("paperStatus".equals(queryField.getProperty())) {
                paperStatus.set(queryField.getValue() + "");
            }
        });
        if (PaperStatusEnum.notRelease.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_start_time_", LocalDateTime.now(), QueryOP.GREAT, FieldRelation.AND);
        } else if (PaperStatusEnum.inTets.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_start_time_", LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
            queryFilter.addFilter("s.plan_end_time_", LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        } else if (PaperStatusEnum.finish.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_end_time_", LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
        }
        if (!StringUtils.isEmpty(paperStatus.get())) {
            queryFilter.getQuerys().removeIf(s -> "paperStatus".equals(s.getProperty()));
        }
        queryFilter.addFilter("b.type_", "1", QueryOP.EQUAL);
        List<String> statusList = Lists.newArrayList();
        statusList.add("1");
        statusList.add("2");
        queryFilter.addFilter("s.status_", statusList, QueryOP.IN);
        queryFilter.addFilter("b.is_dele_", "0", QueryOP.EQUAL);
        return userRecordManager.paperStatistical(queryFilter);
    }


    @PostMapping(value = "/paperAnalysis", produces = {"application/json; charset=utf-8"})
    @ApiOperation("试卷分析")
    public PaperAnalysisVo paperAnalysis() {
        return userRecordManager.paperAnalysis();
    }

    @PostMapping(value = "/questionAnalysis", produces = {"application/json; charset=utf-8"})
    @ApiOperation("题库分析")
    public QuestionAnalysisVo questionAnalysis(@ApiParam(name = "reqVo", value = "入参") @RequestBody StatisticalReqVo reqVo) {
        return questionsInfoManager.questionAnalysis(reqVo);
    }

    @PostMapping(value = "/jobStatistical", produces = {"application/json; charset=utf-8"})
    @ApiOperation("工作台统计")
    public JobStatisticalVo jobStatistical() {
        return userRecordManager.jobStatistical();
    }


}
