package com.artfess.data.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 课目成绩统计表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wsf
 * @since 2025-01-15
 */
@ApiModel(value="BizSubjectScoreCount对象", description="课目成绩统计表")
@TableName("biz_subject_score_count")
@Data
public class BizSubjectScoreCount extends AutoFillModel<BizSubjectScoreCount> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案ID")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "统计年份")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "课目数量")
    @TableField("subjects_")
    private Integer subjects;

    @ApiModelProperty(value = "课目总数量")
    @TableField("subjects_total_")
    private Integer subjectsTotal;

    @ApiModelProperty(value = "所占比例")
    @TableField("ratio_")
    private BigDecimal ratio;

    @ApiModelProperty(value = "类型（字典：1-优秀，2-良好以上，3-及格以上，4-不及格）")
    @TableField("type_")
    private Integer type;

    @ApiModelProperty(value = "排序号（前端展示行号）")
    @TableField("sn_")
    private Integer sn;
}
