package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.data.dao.BizTeachingResourcesTypeDao;
import com.artfess.data.manager.BizEquipmentKnowledgeDataManager;
import com.artfess.data.manager.BizRegulatoryFileManager;
import com.artfess.data.manager.BizTeachingResourceDataManager;
import com.artfess.data.manager.BizTeachingResourcesTypeManager;
import com.artfess.data.model.BizEquipmentKnowledgeData;
import com.artfess.data.model.BizRegulatoryFile;
import com.artfess.data.model.BizTeachingResourceData;
import com.artfess.data.model.BizTeachingResourcesType;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 训练知识分类 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizTeachingResourcesTypeManagerImpl extends BaseManagerImpl<BizTeachingResourcesTypeDao, BizTeachingResourcesType> implements BizTeachingResourcesTypeManager {

    @Autowired
    private BizTeachingResourceDataManager teachingResourceDataManager;

    @Autowired
    private BizEquipmentKnowledgeDataManager equipmentKnowledgeDataManager;

    @Autowired
    private BizRegulatoryFileManager regulatoryFileManager;

    @Override
    public List<BizTeachingResourcesType> getTree(BizTeachingResourcesType entity) {
        QueryWrapper<BizTeachingResourcesType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        if (StringUtils.isNotBlank(entity.getType())) {
            queryWrapper.eq("type_", entity.getType());
        }


        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<BizTeachingResourcesType> sysList = this.baseMapper.selectList(queryWrapper);
        List<BizTeachingResourcesType> tree = BeanUtils.listToTree(sysList);
        return tree;
    }

    @Override
    public boolean deleteByIds(List<String> ids) {

        LambdaQueryWrapper<BizTeachingResourcesType> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(BizTeachingResourcesType::getId, ids);
        List<BizTeachingResourcesType> list = this.list(lambdaQueryWrapper);
        if(CollectionUtils.isEmpty(list)) {
            throw new BaseException("训练知识分类数据不存在");
        }
        String type = list.get(0).getType();
        if("1".equals(type)) {
            LambdaQueryWrapper<BizTeachingResourceData> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(BizTeachingResourceData::getKnowledgeTypeId, ids);
            List<BizTeachingResourceData> teachingResourceDataList = teachingResourceDataManager.list(queryWrapper);
            if(!CollectionUtils.isEmpty(teachingResourceDataList)) {
                throw new BaseException("该分类下还有教学资源数据");
            }
        }else if("2".equals(type)) {
            LambdaQueryWrapper<BizEquipmentKnowledgeData> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(BizEquipmentKnowledgeData::getKnowledgeTypeId, ids);
            List<BizEquipmentKnowledgeData> equipmentKnowledgeDataList = equipmentKnowledgeDataManager.list(queryWrapper);
            if(!CollectionUtils.isEmpty(equipmentKnowledgeDataList)) {
                throw new BaseException("该分类下还有装备知识数据");
            }
        }else if("3".equals(type)) {
            LambdaQueryWrapper<BizRegulatoryFile> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(BizRegulatoryFile::getKnowledgeTypeId, ids);
            List<BizRegulatoryFile> regulatoryFiles = regulatoryFileManager.list(queryWrapper);
            if(!CollectionUtils.isEmpty(regulatoryFiles)) {
                throw new BaseException("该分类下还有法规文件");
            }
        }
        boolean b = this.removeByIds(ids);
        return b;
    }
}
