/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.data.dto.EditPersonalProfileDto;
import com.artfess.data.dto.PersonalProfileExportDTO;
import com.artfess.data.manager.BizUserBasicManager;
import com.artfess.data.model.BizUserBasic;
import com.artfess.data.vo.PersonalProfileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4e2a\u4eba\u4e2d\u5fc3-\u4e2a\u4eba\u6863\u6848"})
@RequestMapping(value={"/biz/personalProfile"})
@ApiGroup(group={"group_biz"})
public class BizUserBasicController
extends BaseController<BizUserBasicManager, BizUserBasic> {
    private static final Logger log = LoggerFactory.getLogger(BizUserBasicController.class);
    private final BizUserBasicManager bizUserBasicManager;

    public BizUserBasicController(BizUserBasicManager bizUserBasicManager) {
        this.bizUserBasicManager = bizUserBasicManager;
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u6863\u6848(\u81ea\u5df1\u8d26\u53f7)")
    @GetMapping
    public CommonResult<PersonalProfileVo> getPersonalProfile() {
        PersonalProfileVo personalProfileVo = this.bizUserBasicManager.getPersonalProfile();
        return CommonResult.success((Object)personalProfileVo, (String)"\u83b7\u53d6\u4e2a\u4eba\u6863\u6848\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u5e74\u4efd\u548c\u7528\u6237ID\u83b7\u53d6\u4e2a\u4eba\u6863\u6848)")
    @GetMapping(value={"/{year}/{userId}"}, produces={"application/json; charset=utf-8"})
    public CommonResult<PersonalProfileVo> getPersonalProfile(@PathVariable(value="year") String year, @PathVariable(value="userId") String userId) {
        PersonalProfileVo personalProfileVo = this.bizUserBasicManager.getPersonalProfile(year, userId);
        return CommonResult.success((Object)personalProfileVo, (String)"\u83b7\u53d6\u4e2a\u4eba\u6863\u6848\u6210\u529f");
    }

    @ApiOperation(value="\u7f16\u8f91\u4e2a\u4eba\u6863\u6848")
    @PutMapping
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) EditPersonalProfileDto editPersonalProfileDto) {
        this.bizUserBasicManager.editPersonalProfile(editPersonalProfileDto);
        return new CommonResult();
    }

    @ApiOperation(value="\u4e0a\u4f20\u4e2a\u4eba\u56fe\u7247\uff0c\u8fd4\u56deURL")
    @PostMapping(value={"/uploadImage"})
    public CommonResult<String> uploadImage(@ApiParam(name="file", value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file) {
        String url = this.bizUserBasicManager.uploadImage(file);
        return CommonResult.success((Object)url, (String)"\u4e0a\u4f20\u4e2a\u4eba\u56fe\u7247\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u6d41")
    @GetMapping(value={"/download/{fileName}"})
    public void download(@PathVariable(value="fileName") String fileName, HttpServletResponse response) {
        this.bizUserBasicManager.download(fileName, response);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u52fe\u9009\u7528\u6237\u7684\u4e2a\u4eba\u6863\u6848")
    public void export(HttpServletResponse response, @ApiParam(name="PersonalProfileExportDTO", value="\u6863\u6848\u5bfc\u51faDTO") @RequestBody PersonalProfileExportDTO dto) {
        ((BizUserBasicManager)this.baseService).export(dto.getIds(), dto.getYear(), response);
    }
}

