/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.enums.AccessControlTypeEnum;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.examine.dao.ExamMaterialTypeAuthDao;
import com.artfess.examine.manager.ExamMaterialTypeAuthManager;
import com.artfess.examine.model.ExamMaterialAuth;
import com.artfess.examine.vo.ExamMaterialTypeAuthVo;
import com.artfess.examine.vo.ExamMaterialVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamMaterialTypeAuthManagerImpl
extends BaseManagerImpl<ExamMaterialTypeAuthDao, ExamMaterialAuth>
implements ExamMaterialTypeAuthManager {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAuth(ExamMaterialVo auth) {
        if (StringUtils.isEmpty((Object)auth.getMaterialId())) {
            throw new RequiredException("\u8d44\u6599\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_id_", (Object)auth.getMaterialId());
        ((ExamMaterialTypeAuthDao)this.baseMapper).delete((Wrapper)queryWrapper);
        if (!AccessControlTypeEnum.ALL.getType().equals(auth.getAccessControlType())) {
            Assert.notEmpty(auth.getAccessControlList(), (String)"\u8bf7\u9009\u62e9\u6743\u9650\u53d7\u63a7\u5bf9\u8c61");
            auth.getAccessControlList().forEach(control -> {
                ExamMaterialAuth materialTypeAuth = new ExamMaterialAuth();
                materialTypeAuth.setMaterialId(auth.getMaterialId());
                materialTypeAuth.setAccessControlType(auth.getAccessControlType());
                materialTypeAuth.setAccessControlId(control.getAccessControlId());
                materialTypeAuth.setAccessControlName(control.getAccessControlName());
                materialTypeAuth.setAuthType(auth.getAuthType());
                ((ExamMaterialTypeAuthDao)this.baseMapper).insert((Object)materialTypeAuth);
            });
        } else {
            ExamMaterialAuth materialAuth = new ExamMaterialAuth();
            materialAuth.setMaterialId(auth.getMaterialId());
            materialAuth.setAccessControlType(auth.getAccessControlType());
            materialAuth.setAuthType(auth.getAuthType());
            ((ExamMaterialTypeAuthDao)this.baseMapper).insert((Object)materialAuth);
        }
    }

    @Override
    public ExamMaterialVo findByTypeId(String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_id_", (Object)typeId);
        List auths = ((ExamMaterialTypeAuthDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)auths)) {
            return new ExamMaterialVo();
        }
        ExamMaterialAuth bizFileTemplateAuth = (ExamMaterialAuth)((Object)auths.get(0));
        ExamMaterialVo typeVo = new ExamMaterialVo();
        BeanUtils.copyProperties((Object)((Object)bizFileTemplateAuth), (Object)typeVo);
        List list = DmpBeanUtil.copyList((List)auths, ExamMaterialTypeAuthVo.class);
        typeVo.setAccessControlList(list);
        return typeVo;
    }
}

