/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.data.dao.BizSubExamDataDao;
import com.artfess.data.manager.BizSubExamDataManager;
import com.artfess.data.model.BizSubExamData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.api.client.util.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizSubExamDataManagerImpl
extends BaseManagerImpl<BizSubExamDataDao, BizSubExamData>
implements BizSubExamDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Resource
    private ExamUserEvaluationDetailDao userEvaluationDetailDao;
    @Resource
    private ExamUserEvaluationManager userEvaluationManager;
    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    public void saveData(List<BizSubExamData> list) {
        Assert.notEmpty(list, (String)"\u5bfc\u5165\u7684\u8bfe\u76ee\u8003\u6838\u6570\u636e\u4e3a\u7a7a");
        String year = String.valueOf(LocalDateTime.now().getYear());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ExamSubjectInfo::getIsDele, (Object)DelStatusEnum.N.getType());
        List subjectInfos = this.subjectInfoManager.list((Wrapper)lambdaQueryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(subExamData -> {
            if (null != subjectInfoMap.get(subExamData.getSubjectName())) {
                subExamData.setSubjectId(((ExamSubjectInfo)((Object)((Object)subjectInfoMap.get(subExamData.getSubjectName())))).getId());
            }
            if (!StringUtil.isEmpty((String)subExamData.getRateLevel())) {
                Integer desc = ScoreLevelEnum.getType((String)subExamData.getRateLevel());
                subExamData.setRateLevel(desc + "");
            }
            subExamData.setYear(year);
        });
        List<PositionVo> positionVoList = this.userEvaluationDetailDao.getPositionList();
        Map<String, PositionVo> positionMap = positionVoList.stream().collect(Collectors.toMap(item -> item.getPositionName(), item -> item));
        Map<String, List<BizSubExamData>> map = list.stream().collect(Collectors.groupingBy(BizSubExamData::getPost));
        map.forEach((post, data) -> {
            if (null == positionMap.get(post)) {
                return;
            }
            ArrayList detail = Lists.newArrayList();
            data.forEach(examData -> {
                ExamUserEvaluationDetail evaluationDetail = new ExamUserEvaluationDetail();
                evaluationDetail.setUserName(examData.getUserName());
                evaluationDetail.setUserName(examData.getUserName());
                evaluationDetail.setPositionId(((PositionVo)positionMap.get(post)).getPositionId());
                if (null != examData.getScore()) {
                    evaluationDetail.setScore(examData.getScore().toString());
                } else {
                    evaluationDetail.setScore("0");
                }
                evaluationDetail.setLevelDesc(examData.getRateLevel());
                evaluationDetail.setSubjectId(examData.getSubjectId());
                detail.add(evaluationDetail);
            });
            this.userEvaluationManager.importExcel(detail, ((PositionVo)positionMap.get(post)).getPositionId());
        });
        this.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(BizSubExamData examData) {
        boolean save = this.save((Object)examData);
        if (save) {
            ArrayList detail = Lists.newArrayList();
            ExamUserEvaluationDetail evaluationDetail = new ExamUserEvaluationDetail();
            evaluationDetail.setUserName(examData.getUserName());
            evaluationDetail.setUserName(examData.getUserName());
            evaluationDetail.setPositionId(examData.getPostId());
            if (null != examData.getScore()) {
                evaluationDetail.setScore(examData.getScore().toString());
            } else {
                evaluationDetail.setScore("0");
            }
            evaluationDetail.setLevelDesc(examData.getRateLevel());
            evaluationDetail.setSubjectId(examData.getSubjectId());
            detail.add(evaluationDetail);
            this.userEvaluationManager.importExcel(detail, examData.getPostId());
        }
        return save;
    }
}

