/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.QuestionTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.vo.SubjectQuestionTypeVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u9898\u5e93\u7ba1\u7406"})
@RequestMapping(value={"/exam/questions/info/"})
@ApiGroup(group={"group_biz"})
public class ExamQuestionsInfoController
extends BaseController<ExamQuestionsInfoManager, ExamQuestionsInfo> {
    private static final Logger log = LoggerFactory.getLogger(ExamQuestionsInfoController.class);

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ExamQuestionsInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamQuestionsInfo> queryFilter) {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("q.type_", Direction.ASC));
        return ((ExamQuestionsInfoManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamQuestionsInfo t) {
        String id = ((ExamQuestionsInfoManager)this.baseService).createInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamQuestionsInfo t) {
        String id = ((ExamQuestionsInfoManager)this.baseService).updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public ExamQuestionsInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamQuestionsInfoManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/findBySubjectId/{subjectId}"})
    @ApiOperation(value="\u6839\u636e\u79d1\u76eeid\u83b7\u53d6\u9898\u578b\u7edf\u8ba1\u60c5\u51b5")
    public List<SubjectQuestionTypeVo> findBySubjectId(@ApiParam(name="subjectId", value="\u79d1\u76eeid") @PathVariable String subjectId) {
        return ((ExamQuestionsInfoManager)this.baseService).findBySubjectId(subjectId);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="subjectId", required=false) String subjectId) {
        try {
            Assert.hasText((String)subjectId, (String)"\u8bf7\u9009\u62e9\u8bfe\u76ee");
            ExcelUtils excelUtil = new ExcelUtils(ExamQuestionsInfo.class);
            List list = excelUtil.importQuestionExcel(null, file.getInputStream());
            list.forEach(question -> {
                question.setSubId(subjectId);
                boolean result = ((ExamQuestionsInfoManager)this.baseService).importExcel((ExamQuestionsInfo)((Object)question));
                if (!result) {
                    throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25");
                }
            });
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamQuestionsInfo> queryFilter) throws Exception {
        PageList page = ((ExamQuestionsInfoManager)this.baseService).query(queryFilter);
        page.getRows().forEach(question -> question.setType(QuestionTypeEnum.getDesc((String)question.getType())));
        ExcelUtils util = new ExcelUtils(ExamQuestionsInfo.class);
        util.exportExcel(response, request, page.getRows(), "\u95ee\u9898\u4fe1\u606f");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/questionInfo.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u9898\u5e93\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }
}

