/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.sysConfig.util.SysPropertyUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.ServletContext;

public class AppFileUtil {
    private static ServletContext servletContext;

    public static String getAttachPath() {
        return SysPropertyUtil.getByAlias((String)"file.upload", (String)"D:\\x7\\file");
    }

    public static String getSaveType(String propertiesId) {
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
            FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
            if (BeanUtils.isEmpty((Object)uploadProperties)) {
                uploadProperties = uploadPropertiesManager.getByFlowKey(propertiesId);
            }
            if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                return uploadProperties.getUploadType();
            }
        }
        return SysPropertyUtil.getByAlias((String)"file.saveType", (String)DefaultFile.SAVE_TYPE_DTABASE);
    }

    public static String getSaveTypeByStoage(String stoageId) {
        FileStorageManager fileStorageManager;
        FileStorage fileStorage;
        if (StringUtil.isNotEmpty((String)stoageId) && BeanUtils.isNotEmpty((Object)((Object)(fileStorage = (FileStorage)(fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class)).get((Serializable)((Object)stoageId)))))) {
            return fileStorage.getUploadType();
        }
        return SysPropertyUtil.getByAlias((String)"file.saveType", (String)DefaultFile.SAVE_TYPE_DTABASE);
    }

    public static String getFileSaveTypeByConfig(String code) {
        FileConfigManager fileConfigManager;
        FileStorageConfigDTO fileStorageConfig;
        if (StringUtil.isNotEmpty((String)code) && BeanUtils.isNotEmpty((Object)(fileStorageConfig = (fileConfigManager = (FileConfigManager)AppUtil.getBean(FileConfigManager.class)).getFileConfigByCode(code)))) {
            return fileStorageConfig.getUploadType();
        }
        return SysPropertyUtil.getByAlias((String)"file.saveType", (String)DefaultFile.SAVE_TYPE_DTABASE);
    }

    public static String createFileMkdirs(String tempPath) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        File one = new File(File.separator + year + File.separator + tenantId + File.separator + month + File.separator + tempPath + File.separator);
        if (!one.exists()) {
            one.mkdirs();
        }
        return one.getPath();
    }

    public static Double getFileSaveSizeByConfig(String code) {
        FileConfigManager fileConfigManager;
        FileStorageConfigDTO fileStorageConfig;
        if (StringUtil.isNotEmpty((String)code) && BeanUtils.isNotEmpty((Object)(fileStorageConfig = (fileConfigManager = (FileConfigManager)AppUtil.getBean(FileConfigManager.class)).getFileConfigByCode(code)))) {
            return fileStorageConfig.getAllowSize();
        }
        String fileSize = SysPropertyUtil.getByAlias((String)"file.size", (String)"50");
        return Double.parseDouble(fileSize);
    }

    public static String createFilePath(String tempPath, String fileName) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        File one = new File(File.separator + year + File.separator + tenantId + File.separator + month + File.separator + tempPath + File.separator);
        if (!one.exists()) {
            one.mkdirs();
        }
        return one.getPath() + File.separator + fileName;
    }

    public static String getBasePath() {
        String attachPath = AppFileUtil.getAttachPath();
        if (StringUtil.isEmpty((String)attachPath)) {
            attachPath = AppFileUtil.getRealPath("/attachFiles/temp");
        }
        attachPath = StringUtil.trimSufffix((String)attachPath, (String)"\\");
        attachPath = StringUtil.trimSufffix((String)attachPath, (String)"/");
        return attachPath;
    }

    public static String createPath(String tempPath, String fileName) {
        File one = new File(tempPath);
        if (!one.exists()) {
            one.mkdirs();
        }
        return one.getPath() + File.separator + fileName;
    }

    public static void init(ServletContext _servletContext) {
        servletContext = _servletContext;
    }

    public static String getRealPath(String path) {
        return servletContext.getRealPath(path);
    }
}

