import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/data/abilityEvaluation/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/data/abilityEvaluation/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/data/abilityEvaluation/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/data/abilityEvaluation/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/data/abilityEvaluation/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/data/abilityEvaluation/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/data/abilityEvaluation/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
