import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加题目
    addQuestions(data, cb) {
        req.post(portal + `/exam/questions/info/`, data).then(res => {
            cb(res.data)
        })
    },
    // 题目列表
    getQuestions(data, cb) {
        req.post(portal + `/exam/questions/info/query`, data).then(res => {
            cb(res.data)
        })
    },
	// 获取课目分类下拉树
	getSubTree(data, cb) {
	    req.post(portal + `/exam/subject/info/getTree`, data).then(res => {
	        cb(res.data)
	    })
	},
    // 修改题目
    editQuestions(data, cb) {
        req.put(portal + `/exam/questions/info/`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询题目
    detailId(id, cb) {
        req.get(portal + `/exam/questions/info/` + id).then(rep => {
            cb(rep.data)
        })
    },
    // 删除单个
    deleteOneQuestions(ids, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/exam/questions/info/' + ids).then(res => {
                resolve(res);
            }, error => {
                reject(error);
            })
        })
    },
    // 批量删除
    deleteQuestions(ids, cb) {
        req.remove(portal + `/exam/questions/info/?ids=` + ids).then(rep => {
            cb(rep.data)
        })
    },
	//获取专业装备下拉树
	majorQuery(data, cb) {
	    req.post(portal + `/exam/equipment/sys/getTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//专业id查询课目
	findByMajorIds(data, cb) {
	    req.post(portal + `/exam/subject/info/findByPage`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导入
	importExcel(data, cb) {
	    req.post(portal + `/exam/questions/info/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.post(portal + `/exam/questions/info/export`, data, 'blob').then(res => {
		    cb(res.data)
		})
	},
	//获取未被年度考核选择的科目信息
	notSubjectPage(data, cb) {
	    req.post(portal + `/exam/subject/info/notSubjectPage`, data).then(res => {
	        cb(res.data)
	    })
	},
	//岗位树
	getPositionPage(data, cb) {
	    req.post(portal + `/api/org/v1/orgs/getPositionTree`, data).then(res => {
	        cb(res.data)
	    })
	},
	//课目列表
	queryAssess(data, cb) {
	    req.post(portal + `/exam/year/assessmentSub/findByPage`, data).then(res => {
	        cb(res.data)
	    })
	},
	getSubjects(data, cb) {
		req.post(portal + `/exam/subject/info/getTree`, data).then(res => {
			cb(res.data)
		})
	},
}