import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/exam/plan/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/exam/plan/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/exam/plan/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/exam/plan/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/exam/plan/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel(type) {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/exam/plan/downModel/` + type)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}, type) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/exam/plan/export/` + type, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改计划状态
export function updateStatus(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/exam/plan/updateStatus?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 考勤记录模板下载
export function attendanceDownload() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/userCheck/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 考勤记录导出
export function attendanceExport(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/userCheck/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 考勤记录导入
export function saveUserCheck(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/userCheck/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 个人训练计划
export function myTrainPlan(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/userTrain/plan/myTrainPlan`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 个人训练计划
export function dwExamPlan(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/exam/plan/findByPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 获取教练训练课目列表
export function coachSubjectList(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/exam/subject/info/coachSubjectList`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 获取教练训练课目列表
export function updateDate(ids) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/userCheck/updateStatus?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
