import req from '@/request.js'
import Cookie from 'js-cookie'
const uc = window.context.uc
export default {

    // 用户中心点击进去系统验证tokenKey获取token
    authFormUserTokenKey(tokenKey){
        return new Promise((resolve, reject) => {
            req.request({
                url: "/zsdoor/user/portal/validateKey",
                method: 'post',
                data: tokenKey
            }).then(resp => {
                resolve(resp.data)
            }, error => {
                reject(error)
            }).catch(err=>{
                reject(err)
            })
        })
    },
    // 用户中心点击进去系统验证token获取用户信息
    authUserInfo(token){
        return new Promise((resolve, reject) => {
            req.request({
                url: "/zsdoor/user/user/getCurrentUserInfo",
                method: 'get',
                headers: token
            }).then(resp => {
                resolve(resp.data)
            }, error => {
                reject(error)
            }).catch(err=>{
                reject(err)
            })
        })
    },
    updateUserPsw(param) {
        return new Promise((resolve, reject) => {
            req.post(uc + '/api/user/v1/user/updateUserPsw', param).then(resp => {
                resolve(resp.data)
            }, error => {
                reject(error)
            })
        })
    },
    getSuperior(underId, demId) {
        return new Promise((resolve, reject) => {
            req.get(uc + `/api/user/v1/user/superior?underId=${underId}&demId=${demId}`).then(response => {
                resolve(response.data);
            }, error => {
                reject(error);
            })
        })
    },
    getDefaultPwdStrategy() {
        return new Promise((resolve, reject) => {
            req.get(`${uc}/api/pwdStrategy/v1/getDefault`).then(
                resp => {
                    resolve(resp.data);
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    getDefPwdStrategy(cb) {
        req.get(uc + "/api/pwdStrategy/v1/getDefault").then(response => {
            cb(response.data);
        });
    },
    getUser(param) {
        return new Promise((resolve, reject) => {
            req.get(uc + `/api/user/v1/user/getDetailByAccountOrId?account=${param}`).then(rep => {
                resolve(rep.data)
            }, error => {
                reject(error)
            })
        })
    },
    getUserByAccount(account, cb) {
        req.get(uc + `/api/user/v1/user/getDetailByAccountOrId?account=${account}`).then(rep => {
            cb(rep.data);
        });
    },
    saveUserOrgs(param) {
        return new Promise((resolve, reject) => {
            req.post(uc + '/api/org/v1/orgUser/addOrgUserByCode?account=' + param.account + '&orgCode=' + param.orgCode).then(resp => {
                resolve(resp.data)
            }), error => {
                reject(error)
            }
        })
    },
    getOrgUserQuery(param) {
        return new Promise((resolve, reject) => {
            req.post(uc + '/api/user/v1/users/getOrgUserQuery', param).then(response => {
                resolve(response.data);
            }, error => {
                reject(error);
            });
        })
    },
    deleteOrg(param) {
        return new Promise((resolve, reject) => {
            req.remove(uc + `/Company/v1/removes?ids=${param.id}&&code=${param.code}`).then(
                response => {
                    resolve(response.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    getUserOrgPage(param) {
        return new Promise((resolve, reject) => {
            req.post(uc + '/api/org/v1/orgs/getUserOrgPage', param).then(resp => {
                    resolve(resp.data)
                }),
                error => {
                    reject(error)
                }
        })
    },
    // 获取所有的用户参数
    getUserParams() {
        return new Promise((resolve, reject) => {
            req.get(uc + '/api/params/v1/userParams/getUserParams').then(resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                })
        })
    },
    getUserByUserId(userId) {
        return new Promise((resolve, reject) => {
            req
                .get(uc + '/api/org/v1/orgpost/getUserByUserId?userId=' + userId)
                .then(resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                })
        })
    },
    //未读消息
    messagelist() {
        return new Promise((resolve, reject) => {
            req.post(uc + `/msg/messageReceiver/v1/listNoPage`).then(
                response => {
                    resolve(response)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    getCurrent(cb) {
        req.post(uc + `/api/user/v1/user/getByAccount`).then(rep => {
            cb(rep)
        })
    },
    getUserByAccount(account, cb) {
        req
            .get(uc + `/api/user/v1/user/getDetailByAccountOrId?account=${account}`)
            .then(rep => {
                cb(rep.data)
            })
    },

    authentication(principal, cb, errorCb) {
        let Base64 = require('js-base64').Base64
        let password = Base64.encode(principal.password);
        // 输入框中的密码应该是明文。 这里直接加密提交数据
        req
            .post(uc + `/auth?tenantId=${principal.tenantId || ''}`, {
                username: principal.account,
                password
            })
            .then(function (rep) {
                if (rep.status == 200) {
                    cb(rep.data)
                    if (principal.remberPwd == 1) {
                        Cookie.set('remberPwd', principal.remberPwd, {
                            expires: 7,
                            path: '/     '
                        })
                        Cookie.set('account', principal.account, {
                            expires: 7,
                            path: '/'
                        })
                        Cookie.set('accountPwd', password, {
                            expires: 7,
                            path: '/'
                        }) // 存的是密文
                    } else {
                        Cookie.set('remberPwd', 0)
                        Cookie.set('account', '')
                        Cookie.set('accountPwd', '')
                    }
                } else {
                    errorCb(rep.data.message)
                }
            })
            .catch(function (error) {
                if (
                    error.response &&
                    error.response.data &&
                    error.response.data.message
                ) {
                    errorCb(error.response.data.message)
                } else {
                    errorCb(error.message)
                }
            })
    },
    refreshAndGetAuthenticationToken() {
        return new Promise((resolve, reject) => {
            req
                .get(`${uc}/refresh`)
                .then(function (rep) {
                    resolve(rep.data)
                })
                .catch(function (error) {
                    reject(error.message)
                })
        })
    },
    logout() {
        return req.get(`${uc}/signout`)
    },
    basicSso(token, cb, errorCb) {
        let service = localStorage.getItem('service')
        req
            .get(uc + `/sso/auth?ticket=${token}&code=${token}&service=${service}`)
            .then(function (rep) {
                if (!window.ssoConfig.mode || window.ssoConfig.mode == 'jwt') {
                    if (token.substr(0, 1) === ' ') {
                        token = token.substr(1)
                    }
                    rep.data.token = token
                }
                cb(rep.data)
            })
            .catch(function (error) {
                errorCb(error.message)
            })
    },

    modifyPwd(data, cb) {
        req.post(uc + `/api/user/v1/user/changUserPsd`, data).then(rep => {
            cb(rep.data)
        })
    },

    getAllUser(){
        return new Promise((resolve, reject) => {
            req
                .get(`${uc}/api/user/v1/users/getAllUser`)
                .then(function (rep) {
                    resolve(rep.data)
                })
                .catch(function (error) {
                    reject(error.message)
                })
        })
    },

    getAllDimension(cb, errorCb) {
        req
            .get(uc + '/api/demension/v1/dems/getAll')
            .then(function (rep) {
                cb(rep.data)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },

    getOrgsByDemension(demensionId, cb, errorCb) {
        req
            .post(uc + '/api/org/v1/orgs/getByParentAndDem', {
                demId: demensionId
            })
            .then(function (rep) {
                cb(rep.data)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },

    getOrgsByParentIdAndDemension(parentId, demensionId, cb, errorCb) {
        req
            .post(uc + '/api/org/v1/orgs/getByParentAndDem', {
                demId: demensionId,
                parentId: parentId
            })
            .then(function (rep) {
                cb(rep.data)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },

    getUsersByOrgId(queryFilter, cb, errorCb) {
        req
            .post(uc + '/api/user/v1/users/queryByType', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },

    getCurrentOrg(cb) {
        req.get(uc + `/api/org/v1/org/getOrgMaster`).then(rep => {
            cb(rep)
        })
    },

    queryOrgByFilter(queryFilter, cb, errorCb) {
        req
            .post(uc + '/api/org/v1/orgs/getOrgPage', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },
    getOrgPostPage(queryFilter, cb, errorCb) {
        req
            .post('/api/org/v1/orgPosts/getPositionPage', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },
    getRolePage(queryFilter, cb, errorCb) {
        req
            .post('/api/role/v1/roles/getRolePage', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },
    getJobPage(queryFilter, cb, errorCb) {
        req
            .post('/api/job/v1/jobs/getJobPage', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },
    //查询维度列表
    getDemPage(queryFilter, cb, errorCb) {
        req
            .post(uc + '/api/demension/v1/dems/getDemListAll', queryFilter)
            .then(function (rep) {
                cb(rep)
            })
            .catch(function (error) {
                errorCb && errorCb(error.message)
            })
    },
    //获取默认密码策略
    getDefaultPwdStrategy() {
        return new Promise((resolve, reject) => {
            req.get(`${uc}/api/pwdStrategy/v1/getDefault`).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    getDefPwdStrategy(cb) {
        req.get(uc + '/api/pwdStrategy/v1/getDefault').then(response => {
            cb(response.data)
        })
    },
    fileUpload(param) {
        //文件上传
        return new Promise((resolve, reject) => {
            req.post(uc + '/system/file/v1/fileUpload', param).then(response => {
                    resolve(response.data)
                }),
                error => {
                    reject(error)
                }
        })
    },
    getCurrentSeal() {
        // 获取当前登录用户的电子签章
        return new Promise((resolve, reject) => {
            req
                .get(uc + '/uc/electronicSeal/v1/getSealByCurrentUserId')
                .then(response => {
                    resolve(response.data)
                }),
                error => {
                    reject(error)
                }
        })
    }
}