import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/exam/camera/info/`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改
    editData(data, cb) {
        req.put(portal + `/exam/camera/info/`, data).then(res => {
            cb(res.data)
        })
    },
	//分页查询
	pagingQuery(data, cb) {
	  req.post(portal + `/exam/camera/info/query`, data).then(res => {
	    cb(res.data)
	  })
	},
    // id查询
    detailId(id, cb) {
        req.get(portal + `/exam/camera/info/` + id).then(rep => {
            cb(rep.data)
        })
    },
	//保存排序
	saveSort(data, cb) {
	    req.post(portal + `/exam/camera/info/updateSequence/`, data).then(res => {
	        cb(res.data)
	    })
	},
	//所属考场查询
	roomQuery(data, cb) {
	  req.post(portal + `/exam/room/info/query`, data).then(res => {
	    cb(res.data)
	  })
	},
}