import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentKnowledge/data/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/equipmentKnowledge/data/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentKnowledge/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/equipmentKnowledge/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/equipmentKnowledge/data/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/equipmentKnowledge/data/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/equipmentKnowledge/data/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改计划状态
export function updateStatus(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/equipmentKnowledge/data/updateStatus?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


// 月度总结详情
export function monthlyDetails(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/bizMonthPlanFile/v1/query`,data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 月度总结新增
export function monthlyAdditions(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/bizMonthPlanFile/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 月度总结编辑
export function monthlyEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/bizMonthPlanFile/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}