import req from '@/request.js'
const portal = window.context.portal
export default {
	/**
	 * 课目管理
	 * */
	// 添加课目
	addsubject(data, cb) {
		req.post(portal + `/biz/subExam/data/`, data).then(res => {
			cb(res.data)
		})
	},
	// 课目列表
	getSubjects(data, cb) {
		req.post(portal + `/biz/subExam/data/query`, data).then(res => {
			cb(res.data)
		})
	},
	// 修改课目信息
	editSubject(data, cb) {
		req.put(portal + `/biz/subExam/data/`, data).then(res => {
			cb(res.data)
		})
	},
	// id查询课目信息
	detailId(id, cb) {
		req.get(task + `/exam/subject/info/` + id).then(rep => {
			cb(rep.data)
		})
	},
	// 删除单个
	deleteOneSubject(ids, cb) {
		return new Promise((resolve, reject) => {
			req.remove(portal + '/exam/subject/info/' + ids).then(res => {
				resolve(res);
			}, error => {
				reject(error);
			})
		})
	},
	// 批量删除
	deleteEqeSys(ids) {
		return new Promise((resolve, reject) => {
			req
				.remove(portal + `/biz/subExam/data/?ids=${ids}`)
				.then(res => resolve(res?.data || {}))
				.catch(err => reject(err))
		})




	},
	// 获取岗位信息
	getPosition(data, cb) {
		req.post(portal + `/api/org/v1/orgPosts/getPositionPage`, data).then(res => {
			cb(res.data)
		})
	},
	// 列表排序
	saveSort(data, cb) {
		req.post(portal + `/biz/subExam/data/updateSequence`, data).then(res => {
			cb(res.data)
		})
	},
	/**
	 * 课目分类
	 * */
	// 获取课目分类下拉树
	getSubTree(data, cb) {
		req.post(portal + `/exam/subject/type/getTree`, data).then(res => {
			cb(res.data)
		})
	},
	// 添加课目分类
	addSubjectClass(data, cb) {
		req.post(portal + `/biz/subExam/data/`, data).then(res => {
			cb(res.data)
		})
	},
	// 修改课目分类
	editSubjectClass(data, cb) {
		req.put(portal + `/exam/subject/type/`, data).then(res => {
			cb(res.data)
		})
	},

	// 删除单个课目分类
	deleteSubjectClass(ids, cb) {
		return new Promise((resolve, reject) => {
			req.remove(portal + '/exam/subject/type/' + ids).then(res => {
				resolve(res);
			}, error => {
				reject(error);
			})
		})
	},
	//查询人员类别
	getJobPage(data, cb) {
		req.post(portal + `/api/job/v1/jobs/getJobPage`, data).then(res => {
			cb(res.data)
		})
	},
	//获取组织
	getOrgPostPage(data, cb) {
		req.post(portal + `/api/org/v1/orgPosts/getPositionPage`, data).then(res => {
			cb(res.data)
		})
	},
	//根据专业id查询组织岗位
	findById(ids, cb) {
		req.get(portal + `/biz/subExam/data/` + ids).then(rep => {
			cb(rep.data)
		})
	},


	//导入
	importExcel(data, cb) {
	    req.post(portal + `/biz/subExam/data/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.post(portal + `/biz/subExam/data/export`, data, 'blob').then(res => {
		    cb(res.data)
		})
	}
}
