import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/archives/orgArchives`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(
        portal + `/biz/archives/orgArchives/exportWord`,
        data,
        'arraybuffer'
      )
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
