import * as vue_demi from 'vue-demi';
import { PropType } from 'vue-demi';
import * as echarts_types_dist_shared from 'echarts/types/dist/shared';
import { init } from 'echarts/core';

declare type InitType = typeof init;
declare type EChartsType = ReturnType<InitType>;
declare type SetOptionType = EChartsType["setOption"];
declare type Option = Parameters<SetOptionType>[0];

declare const LOADING_OPTIONS_KEY = "ecLoadingOptions";

declare const THEME_KEY = "ecTheme";
declare const INIT_OPTIONS_KEY = "ecInitOptions";
declare const UPDATE_OPTIONS_KEY = "ecUpdateOptions";

declare const _default: vue_demi.DefineComponent<{
    loading: BooleanConstructor;
    loadingOptions: ObjectConstructor;
    autoresize: BooleanConstructor;
    option: PropType<echarts_types_dist_shared.ECBasicOption>;
    theme: {
        type: PropType<string | object>;
    };
    initOptions: PropType<{
        locale?: string | {
            time: {
                month: string[];
                monthAbbr: string[];
                dayOfWeek: string[];
                dayOfWeekAbbr: string[];
            };
            legend: {
                selector: {
                    all: string;
                    inverse: string;
                };
            };
            toolbox: {
                brush: {
                    title: {
                        rect: string;
                        polygon: string;
                        lineX: string;
                        lineY: string;
                        keep: string;
                        clear: string;
                    };
                };
                dataView: {
                    title: string;
                    lang: string[];
                };
                dataZoom: {
                    title: {
                        zoom: string;
                        back: string;
                    };
                };
                magicType: {
                    title: {
                        line: string;
                        bar: string;
                        stack: string;
                        tiled: string;
                    };
                };
                restore: {
                    title: string;
                };
                saveAsImage: {
                    title: string;
                    lang: string[];
                };
            };
            series: {
                typeNames: {
                    pie: string;
                    bar: string;
                    line: string;
                    scatter: string;
                    effectScatter: string;
                    radar: string;
                    tree: string;
                    treemap: string;
                    boxplot: string;
                    candlestick: string;
                    k: string;
                    heatmap: string;
                    map: string;
                    parallel: string;
                    lines: string;
                    graph: string;
                    sankey: string;
                    funnel: string;
                    gauge: string;
                    pictorialBar: string;
                    themeRiver: string;
                    sunburst: string;
                };
            };
            aria: {
                general: {
                    withTitle: string;
                    withoutTitle: string;
                };
                series: {
                    single: {
                        prefix: string;
                        withName: string;
                        withoutName: string;
                    };
                    multiple: {
                        prefix: string;
                        withName: string;
                        withoutName: string;
                        separator: {
                            middle: string;
                            end: string;
                        };
                    };
                };
                data: {
                    allData: string;
                    partialData: string;
                    withName: string;
                    withoutName: string;
                    separator: {
                        middle: string;
                        end: string;
                    };
                };
            };
        } | undefined;
        renderer?: "canvas" | "svg" | undefined;
        devicePixelRatio?: number | undefined;
        useDirtyRect?: boolean | undefined;
        width?: number | undefined;
        height?: number | undefined;
    }>;
    updateOptions: PropType<Pick<echarts_types_dist_shared.SetOptionOpts, "lazyUpdate" | "silent" | "replaceMerge" | "transition">>;
    group: StringConstructor;
    manualUpdate: BooleanConstructor;
}, {
    getWidth: () => number;
    getHeight: () => number;
    getDom: () => HTMLElement;
    getOption: () => echarts_types_dist_shared.ECBasicOption;
    resize: (opts?: echarts_types_dist_shared.ResizeOpts | undefined) => void;
    dispatchAction: (payload: echarts_types_dist_shared.Payload, opt?: boolean | {
        silent?: boolean | undefined;
        flush?: boolean | undefined;
    } | undefined) => void;
    convertToPixel: {
        (finder: string | {
            seriesIndex?: number | false | number[] | "all" | "none" | undefined;
            seriesId?: string | number | (string | number)[] | undefined;
            seriesName?: string | number | (string | number)[] | undefined;
            geoIndex?: number | false | number[] | "all" | "none" | undefined;
            geoId?: string | number | (string | number)[] | undefined;
            geoName?: string | number | (string | number)[] | undefined;
            bmapIndex?: number | false | number[] | "all" | "none" | undefined;
            bmapId?: string | number | (string | number)[] | undefined;
            bmapName?: string | number | (string | number)[] | undefined;
            xAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            xAxisId?: string | number | (string | number)[] | undefined;
            xAxisName?: string | number | (string | number)[] | undefined;
            yAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            yAxisId?: string | number | (string | number)[] | undefined;
            yAxisName?: string | number | (string | number)[] | undefined;
            gridIndex?: number | false | number[] | "all" | "none" | undefined;
            gridId?: string | number | (string | number)[] | undefined;
            gridName?: string | number | (string | number)[] | undefined;
            dataIndex?: number | undefined;
            dataIndexInside?: number | undefined;
        }, value: string | number | Date): number;
        (finder: string | {
            seriesIndex?: number | false | number[] | "all" | "none" | undefined;
            seriesId?: string | number | (string | number)[] | undefined;
            seriesName?: string | number | (string | number)[] | undefined;
            geoIndex?: number | false | number[] | "all" | "none" | undefined;
            geoId?: string | number | (string | number)[] | undefined;
            geoName?: string | number | (string | number)[] | undefined;
            bmapIndex?: number | false | number[] | "all" | "none" | undefined;
            bmapId?: string | number | (string | number)[] | undefined;
            bmapName?: string | number | (string | number)[] | undefined;
            xAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            xAxisId?: string | number | (string | number)[] | undefined;
            xAxisName?: string | number | (string | number)[] | undefined;
            yAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            yAxisId?: string | number | (string | number)[] | undefined;
            yAxisName?: string | number | (string | number)[] | undefined;
            gridIndex?: number | false | number[] | "all" | "none" | undefined;
            gridId?: string | number | (string | number)[] | undefined;
            gridName?: string | number | (string | number)[] | undefined;
            dataIndex?: number | undefined;
            dataIndexInside?: number | undefined;
        }, value: (string | number | Date)[]): number[];
    };
    convertFromPixel: {
        (finder: string | {
            seriesIndex?: number | false | number[] | "all" | "none" | undefined;
            seriesId?: string | number | (string | number)[] | undefined;
            seriesName?: string | number | (string | number)[] | undefined;
            geoIndex?: number | false | number[] | "all" | "none" | undefined;
            geoId?: string | number | (string | number)[] | undefined;
            geoName?: string | number | (string | number)[] | undefined;
            bmapIndex?: number | false | number[] | "all" | "none" | undefined;
            bmapId?: string | number | (string | number)[] | undefined;
            bmapName?: string | number | (string | number)[] | undefined;
            xAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            xAxisId?: string | number | (string | number)[] | undefined;
            xAxisName?: string | number | (string | number)[] | undefined;
            yAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            yAxisId?: string | number | (string | number)[] | undefined;
            yAxisName?: string | number | (string | number)[] | undefined;
            gridIndex?: number | false | number[] | "all" | "none" | undefined;
            gridId?: string | number | (string | number)[] | undefined;
            gridName?: string | number | (string | number)[] | undefined;
            dataIndex?: number | undefined;
            dataIndexInside?: number | undefined;
        }, value: number): number;
        (finder: string | {
            seriesIndex?: number | false | number[] | "all" | "none" | undefined;
            seriesId?: string | number | (string | number)[] | undefined;
            seriesName?: string | number | (string | number)[] | undefined;
            geoIndex?: number | false | number[] | "all" | "none" | undefined;
            geoId?: string | number | (string | number)[] | undefined;
            geoName?: string | number | (string | number)[] | undefined;
            bmapIndex?: number | false | number[] | "all" | "none" | undefined;
            bmapId?: string | number | (string | number)[] | undefined;
            bmapName?: string | number | (string | number)[] | undefined;
            xAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            xAxisId?: string | number | (string | number)[] | undefined;
            xAxisName?: string | number | (string | number)[] | undefined;
            yAxisIndex?: number | false | number[] | "all" | "none" | undefined;
            yAxisId?: string | number | (string | number)[] | undefined;
            yAxisName?: string | number | (string | number)[] | undefined;
            gridIndex?: number | false | number[] | "all" | "none" | undefined;
            gridId?: string | number | (string | number)[] | undefined;
            gridName?: string | number | (string | number)[] | undefined;
            dataIndex?: number | undefined;
            dataIndexInside?: number | undefined;
        }, value: number[]): number[];
    };
    containPixel: (finder: string | {
        seriesIndex?: number | false | number[] | "all" | "none" | undefined;
        seriesId?: string | number | (string | number)[] | undefined;
        seriesName?: string | number | (string | number)[] | undefined;
        geoIndex?: number | false | number[] | "all" | "none" | undefined;
        geoId?: string | number | (string | number)[] | undefined;
        geoName?: string | number | (string | number)[] | undefined;
        bmapIndex?: number | false | number[] | "all" | "none" | undefined;
        bmapId?: string | number | (string | number)[] | undefined;
        bmapName?: string | number | (string | number)[] | undefined;
        xAxisIndex?: number | false | number[] | "all" | "none" | undefined;
        xAxisId?: string | number | (string | number)[] | undefined;
        xAxisName?: string | number | (string | number)[] | undefined;
        yAxisIndex?: number | false | number[] | "all" | "none" | undefined;
        yAxisId?: string | number | (string | number)[] | undefined;
        yAxisName?: string | number | (string | number)[] | undefined;
        gridIndex?: number | false | number[] | "all" | "none" | undefined;
        gridId?: string | number | (string | number)[] | undefined;
        gridName?: string | number | (string | number)[] | undefined;
        dataIndex?: number | undefined;
        dataIndexInside?: number | undefined;
    }, value: number[]) => boolean;
    getDataURL: (opts?: {
        type?: "svg" | "png" | "jpg" | undefined;
        pixelRatio?: number | undefined;
        backgroundColor?: string | echarts_types_dist_shared.LinearGradientObject | echarts_types_dist_shared.RadialGradientObject | echarts_types_dist_shared.ImagePatternObject | echarts_types_dist_shared.SVGPatternObject | undefined;
        excludeComponents?: string[] | undefined;
    } | undefined) => string;
    getConnectedDataURL: (opts?: {
        type?: "svg" | "png" | "jpg" | undefined;
        pixelRatio?: number | undefined;
        backgroundColor?: string | echarts_types_dist_shared.LinearGradientObject | echarts_types_dist_shared.RadialGradientObject | echarts_types_dist_shared.ImagePatternObject | echarts_types_dist_shared.SVGPatternObject | undefined;
        connectedBackgroundColor?: string | echarts_types_dist_shared.LinearGradientObject | echarts_types_dist_shared.RadialGradientObject | echarts_types_dist_shared.ImagePatternObject | echarts_types_dist_shared.SVGPatternObject | undefined;
        excludeComponents?: string[] | undefined;
    } | undefined) => string;
    appendData: (params: {
        seriesIndex: number;
        data: any;
    }) => void;
    clear: () => void;
    isDisposed: () => boolean;
    dispose: () => void;
    chart: vue_demi.ShallowRef<echarts_types_dist_shared.EChartsType | undefined>;
    root: vue_demi.ShallowRef<HTMLElement | undefined>;
    setOption: (option: Option, updateOptions?: Pick<echarts_types_dist_shared.SetOptionOpts, "lazyUpdate" | "silent" | "replaceMerge" | "transition"> | undefined) => void;
    nonEventAttrs: vue_demi.ComputedRef<{
        [key: string]: any;
    }>;
}, unknown, {}, {}, vue_demi.ComponentOptionsMixin, vue_demi.ComponentOptionsMixin, Record<string, any>, string, vue_demi.VNodeProps & vue_demi.AllowedComponentProps & vue_demi.ComponentCustomProps, Readonly<{
    loading?: unknown;
    loadingOptions?: unknown;
    autoresize?: unknown;
    option?: unknown;
    theme?: unknown;
    initOptions?: unknown;
    updateOptions?: unknown;
    group?: unknown;
    manualUpdate?: unknown;
} & {
    loading: boolean;
    autoresize: boolean;
    manualUpdate: boolean;
} & {
    loadingOptions?: Record<string, any> | undefined;
    option?: echarts_types_dist_shared.ECBasicOption | undefined;
    theme?: string | object | undefined;
    initOptions?: {
        locale?: string | {
            time: {
                month: string[];
                monthAbbr: string[];
                dayOfWeek: string[];
                dayOfWeekAbbr: string[];
            };
            legend: {
                selector: {
                    all: string;
                    inverse: string;
                };
            };
            toolbox: {
                brush: {
                    title: {
                        rect: string;
                        polygon: string;
                        lineX: string;
                        lineY: string;
                        keep: string;
                        clear: string;
                    };
                };
                dataView: {
                    title: string;
                    lang: string[];
                };
                dataZoom: {
                    title: {
                        zoom: string;
                        back: string;
                    };
                };
                magicType: {
                    title: {
                        line: string;
                        bar: string;
                        stack: string;
                        tiled: string;
                    };
                };
                restore: {
                    title: string;
                };
                saveAsImage: {
                    title: string;
                    lang: string[];
                };
            };
            series: {
                typeNames: {
                    pie: string;
                    bar: string;
                    line: string;
                    scatter: string;
                    effectScatter: string;
                    radar: string;
                    tree: string;
                    treemap: string;
                    boxplot: string;
                    candlestick: string;
                    k: string;
                    heatmap: string;
                    map: string;
                    parallel: string;
                    lines: string;
                    graph: string;
                    sankey: string;
                    funnel: string;
                    gauge: string;
                    pictorialBar: string;
                    themeRiver: string;
                    sunburst: string;
                };
            };
            aria: {
                general: {
                    withTitle: string;
                    withoutTitle: string;
                };
                series: {
                    single: {
                        prefix: string;
                        withName: string;
                        withoutName: string;
                    };
                    multiple: {
                        prefix: string;
                        withName: string;
                        withoutName: string;
                        separator: {
                            middle: string;
                            end: string;
                        };
                    };
                };
                data: {
                    allData: string;
                    partialData: string;
                    withName: string;
                    withoutName: string;
                    separator: {
                        middle: string;
                        end: string;
                    };
                };
            };
        } | undefined;
        renderer?: "canvas" | "svg" | undefined;
        devicePixelRatio?: number | undefined;
        useDirtyRect?: boolean | undefined;
        width?: number | undefined;
        height?: number | undefined;
    } | undefined;
    updateOptions?: Pick<echarts_types_dist_shared.SetOptionOpts, "lazyUpdate" | "silent" | "replaceMerge" | "transition"> | undefined;
    group?: string | undefined;
}>, {
    loading: boolean;
    autoresize: boolean;
    manualUpdate: boolean;
}>;

export default _default;
export { INIT_OPTIONS_KEY, LOADING_OPTIONS_KEY, THEME_KEY, UPDATE_OPTIONS_KEY };
