package com.artfess.uc.params.org;

import com.artfess.base.model.Tree;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.model.Org;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <pre>
 * 描述：组织架构 实体对象
 * 构建组：x5-bpmx-platform
 * 作者:ray
 * 邮箱:zhangyg@jee-soft.cn
 * 日期:2016-06-28 15:13:03
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@Data
@ApiModel(description = "组织架构 ")
public class OrgTreeVo implements Tree {


    /**
     * 主键
     */
    @ApiModelProperty(name = "id", notes = "组织id")
    protected String id;

    /**
     * name_
     */
    @ApiModelProperty(name = "name", notes = "组织名称")
    protected String name;

    /**
     * prent_id_
     */
    @ApiModelProperty(name = "parentId", notes = "组织父节点id")
    protected String parentId;

    /**
     * code_
     */
    @ApiModelProperty(name = "code", notes = "组织编码")
    protected String code;

    /**
     * 级别
     */
    @ApiModelProperty(name = "grade", notes = "组织级别")
    protected String grade;

    /**
     * 组织类型（ogn,dept）
     */
    @ApiModelProperty(name = "orgKind", notes = "组织类型（ogn,dept）")
    protected String orgKind;

    /**
     * 维度Id
     */
    @ApiModelProperty(name = "demId", notes = "维度id")
    protected String demId;

    @ApiModelProperty(name = "orderNo", notes = "序号")
    protected Long orderNo;

    /**
     * 上级组织名称
     */
    @ApiModelProperty(name = "parentOrgName", notes = "上级组织名称")
    protected String parentOrgName;

    /**
     * 是否主组织。
     */
    @ApiModelProperty(name = "isMaster", notes = "是否主组织")
    private int isMaster = 0;

    /**
     * /**
     * 路径
     */
    @ApiModelProperty(name = "path", notes = "路径")
    protected String path;

    /**
     * 组织路径名
     */
    @ApiModelProperty(name = "pathName", notes = "组织路径名")
    protected String pathName;
    /**
     * 是否有子节点   否0  是1
     */
    @ApiModelProperty(name = "isIsParent", notes = "是否有子节点   否0  是1")
    protected boolean isIsParent;

    @ApiModelProperty(name = "limitNum", notes = "组织限编用户数量(0:不受限制)")
    protected Integer limitNum = 0;

    @ApiModelProperty(name = "nowNum", notes = "组织现编用户数量")
    protected Integer nowNum;

    @ApiModelProperty(name = "exceedLimitNum", notes = "是否允许超过限编(0:允许；1:不允许)")
    protected Integer exceedLimitNum = 0;

    @ApiModelProperty(name = "addvcd", notes = "行政区划编码")
    protected String addvcd;

    @ApiModelProperty(name = "addvcdName", notes = "行政区划名称")
    protected String addvcdName;

    @ApiModelProperty(name = "addvcdFull", notes = "行政区划编码全路径")
    protected String addvcdFull;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    protected List<OrgTreeVo> children = new ArrayList<OrgTreeVo>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setIsParent(String isParent) {

    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    public OrgTreeVo(Org group) {
        this.id =group.getId();
        this.name = group.getName();
        this.code = group.getCode();
        this.parentId = group.getParentId();
        this.demId = group.getDemId();
        this.isIsParent = group.isIsParent();
        this.path = group.getPath();
        this.pathName = group.getPathName();
        this.grade=group.getGrade();
    }
}
