package com.artfess.query.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-03-21
 */
@ApiModel(value="BizQueryResultCondition对象", description="查询结果配置信息（BIZ_QUERY_RESULT_CONDITION）")
@TableName("biz_query_result_condition")
public class BizQueryResultCondition extends BaseModel<BizQueryResultCondition> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("MIAN_ID_")
    private String mianId;

    @ApiModelProperty(value = "查询条件字段值类别（1:普通字段 2:枚举字典 3:多维字典项）")
    @TableField("FIELD_VALUE_TYPE_")
    private Integer fieldValueType;

    @ApiModelProperty(value = "展示的字段ID")
    @TableField("FIELD_ID_")
    private String fieldId;

    @ApiModelProperty(value = "展示的字段名称")
    @TableField("FIELD_NAME_")
    private String fieldName;

    @ApiModelProperty(value = "展示的字段英文名（格式：F_字段编码）")
    @TableField("FIELD_CODE_")
    private String fieldCode;

    @ApiModelProperty(value = "展示的字段类型")
    @TableField("FIELD_TYPE_")
    private String fieldType;

    @ApiModelProperty(value = "枚举和多维_CODE（参考枚举和多维定义的CODE值）")
    @TableField("DIMENSION_ID_")
    private String dimensionId;

    @ApiModelProperty(value = "UI组件类型_标识符（text,select,combox,radio,textarea,date,figure,file）")
    @TableField("UI_COM_CODE_")
    private String uiComCode;

    @ApiModelProperty(value = "枚举和多维字典JSON串值（预处理写入）")
    @TableField("DIMENSION_JSON_")
    private String dimensionJson;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMianId() {
        return mianId;
    }

    public void setMianId(String mianId) {
        this.mianId = mianId;
    }

    public Integer getFieldValueType() {
        return fieldValueType;
    }

    public void setFieldValueType(Integer fieldValueType) {
        this.fieldValueType = fieldValueType;
    }

    public String getFieldId() {
        return fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldCode() {
        return fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getDimensionId() {
        return dimensionId;
    }

    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getUiComCode() {
        return uiComCode;
    }

    public void setUiComCode(String uiComCode) {
        this.uiComCode = uiComCode;
    }

    public String getDimensionJson() {
        return dimensionJson;
    }

    public void setDimensionJson(String dimensionJson) {
        this.dimensionJson = dimensionJson;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryResultCondition{" +
            "id=" + id +
            ", mianId=" + mianId +
            ", fieldValueType=" + fieldValueType +
            ", fieldId=" + fieldId +
            ", fieldName=" + fieldName +
            ", fieldCode=" + fieldCode +
            ", fieldType=" + fieldType +
            ", dimensionId=" + dimensionId +
            ", uiComCode=" + uiComCode +
            ", dimensionJson=" + dimensionJson +
            ", sn=" + sn +
        "}";
    }
}
