package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.query.dao.BizAdvanceQueryMouldConfigDao;
import com.artfess.query.manager.BizAdvanceQueryMouldConfigManager;
import com.artfess.query.model.BizAdvanceQueryMouldConfig;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 高级查询条件配置表(界面动态配置）BIZ_ADVANCE_QUERY_MOULD_CONFIG 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizAdvanceQueryMouldConfigManagerImpl extends BaseManagerImpl<BizAdvanceQueryMouldConfigDao, BizAdvanceQueryMouldConfig> implements BizAdvanceQueryMouldConfigManager {

    @Override
    public List<BizAdvanceQueryMouldConfig> qureyConditionByTag(String tagId) {
        Assert.hasText(tagId, "请选择标签");
        return this.baseMapper.qureyConditionByTag(tagId);
    }
}
