package com.artfess.query.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.query.model.BizQueryMyFollow;
import com.artfess.query.model.BizQueryTagCase;

/**
 * 我的关注记录表（BIZ_QUERY_MY_FOLLOW） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
public interface BizQueryMyFollowManager extends BaseManager<BizQueryMyFollow> {

    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizQueryMyFollow> query(QueryFilter<BizQueryMyFollow> queryFilter);

    /**
    * @Description: 保存关注
    * @param bizQueryMyFollow
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2025/4/1 15:39
    */
    String saveBizQueryMyFollow(BizQueryMyFollow bizQueryMyFollow);
}
