package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryMyFollowManager;
import com.artfess.query.model.BizQueryMyFollow;
import com.artfess.query.model.BizQueryTagCase;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 我的关注记录表（BIZ_QUERY_MY_FOLLOW） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--我的关注记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/myFollow/v1/")
public class BizQueryMyFollowController extends BaseController<BizQueryMyFollowManager, BizQueryMyFollow> {

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询条件")
    public PageList<BizQueryMyFollow> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizQueryMyFollow> queryFilter) {
        return baseService.query(queryFilter);
    }

    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizQueryMyFollow t) {
        String result = baseService.saveBizQueryMyFollow(t);
        if (StringUtil.isEmpty(result)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success(result,"关注成功");
    }
}
