package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 搜索案例数据示意表【不同标签取10个即可】（BIZ_QUERY_TAG_CASE）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizQueryTagCase对象", description="搜索案例数据示意表【不同标签取10个即可】（BIZ_QUERY_TAG_CASE）")
public class BizQueryTagCase extends BaseModel<BizQueryTagCase> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "搜索分类【字典】（1个人 2企业）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "搜索标签ID【外键】（查企业、查老板、查风险）")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "搜索案例内容示例描述")
    @TableField("SEARCH_CONTENT_")
    private String searchContent;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;


    @ApiModelProperty(value = "搜索标签CODE")
    @TableField(exist = false)
    private String searchCode;

    @ApiModelProperty(value = "搜索标签名称")
    @TableField(exist = false)
    private String searchName;

    @JsonIgnore
    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(value="create_org_id_", fill=FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getSearchContent() {
        return searchContent;
    }

    public void setSearchContent(String searchContent) {
        this.searchContent = searchContent;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getSearchCode() {
        return searchCode;
    }

    public void setSearchCode(String searchCode) {
        this.searchCode = searchCode;
    }

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryTagCase{" +
            "id=" + id +
            ", type=" + type +
            ", tagId=" + tagId +
            ", searchContent=" + searchContent +
            ", sn=" + sn +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
        "}";
    }
}
