package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.query.dao.BizQueryTagDao;
import com.artfess.query.manager.BizQueryTagManager;
import com.artfess.query.model.BizQueryTag;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 搜索标签定义表（BIZ_QUERY_TAG） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryTagManagerImpl extends BaseManagerImpl<BizQueryTagDao, BizQueryTag> implements BizQueryTagManager {

    @Override
    public List<Map<String, Object>> countByType(Integer type, String itemType) {
        Assert.notNull(type, "所属类型不能为空！");
        try {
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias("app");
            StringBuffer sql=new StringBuffer("select t.* from APP_ENTERPRISE_SYTJ t where t.type_ = ").append(type);
            if(StringUtil.isNotEmpty(itemType)){
                sql.append(" and t.item_type = '").append(itemType).append("' ");
            }
            sql.append( " order by t.id_  ");
            List<Map<String,Object>> resultList = jdbcTemplate.queryForList(sql.toString());
            return resultList;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
