package com.artfess.dataShare.scheduler.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 任务配置表 ---- 系统ODS采集任务配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-28
 */
@ApiModel(value="BizSchedulerOdsTask对象", description="任务配置表 ---- 系统ODS采集任务配置表")
@TableName("BIZ_SCHEDULER_ODS_TASK")
public class BizSchedulerOdsTask extends BaseModel<BizSchedulerOdsTask> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调度作业ID（外键）")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "调度作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "源头数据源别名 （汇聚层数据库）")
    @TableField("SOURCE_ALIAS_")
    private String sourceAlias;

    @ApiModelProperty(value = "源头数据库中间表名称")
    @TableField("SOURCE_TEMP_TABLE_")
    private String sourceTempTable;

    @ApiModelProperty(value = "源头数据源别名 （ODS库）")
    @TableField("TARGET_ALIAS_")
    private String targetAlias;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getSourceAlias() {
        return sourceAlias;
    }

    public void setSourceAlias(String sourceAlias) {
        this.sourceAlias = sourceAlias;
    }

    public String getSourceTempTable() {
        return sourceTempTable;
    }

    public void setSourceTempTable(String sourceTempTable) {
        this.sourceTempTable = sourceTempTable;
    }

    public String getTargetAlias() {
        return targetAlias;
    }

    public void setTargetAlias(String targetAlias) {
        this.targetAlias = targetAlias;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerOdsTask{" +
            "id=" + id +
            ", jobId=" + jobId +
            ", jobName=" + jobName +
            ", sourceAlias=" + sourceAlias +
            ", sourceTempTable=" + sourceTempTable +
            ", targetAlias=" + targetAlias +
        "}";
    }
}
